#pragma once
#include <drive/backend/background/manager/regular.h>

#include <drive/backend/cars_filter/cars_filter.h>
#include <drive/backend/database/drive_api.h>

class IBackgroundRegularCarsProcessConfig: public IBackgroundRegularProcessConfig {
private:
    TCarsFilter CarsFilter;

public:
    using IBackgroundRegularProcessConfig::IBackgroundRegularProcessConfig;

    virtual void Init(const TYandexConfig::Section* section) override {
        IBackgroundRegularProcessConfig::Init(section);
        auto children = section->GetAllChildren();
        {
            auto it = children.find("CarsFilter");
            if (it != children.end()) {
                CarsFilter.Init(it->second);
            }
        }
    }

    virtual void ToString(IOutputStream& os) const override {
        IBackgroundRegularProcessConfig::ToString(os);
        os << "<CarsFilter>" << Endl;
        CarsFilter.ToString(os);
        os << "</CarsFilter>" << Endl;
    }

    const TCarsFilter& GetCarsFilter() const {
        return CarsFilter;
    }
};

TString FormatDuration(const TDuration& duration);
