#include "history.h"


void TCommonHistoryExportConfig::Init(const TYandexConfig::Section* section) {
    IBackgroundRegularProcessConfig::Init(section);
    YtDataPath = section->GetDirectives().Value("YtDataPath", YtDataPath);
    YtCluster = section->GetDirectives().Value("YtCluster", YtCluster);
    ObjectsLimit = section->GetDirectives().Value("ObjectsLimit", ObjectsLimit);
    StartEventId = section->GetDirectives().Value("StartEventId", StartEventId);
}

void TCommonHistoryExportConfig::ToString(IOutputStream& os) const {
    IBackgroundRegularProcessConfig::ToString(os);
    os << "YtDataPath: " << YtDataPath << Endl;
    os << "YtCluster: " << YtCluster << Endl;
    os << "ObjectsLimit: " << ObjectsLimit << Endl;
    os << "StartEventId: " << StartEventId << Endl;
}

TCommonHistoryExport::TCommonHistoryExport(const TCommonHistoryExportConfig& config)
    : TBase(config)
    , Config(config)
    , LastEventId(Config.GetStartEventId())
{
}

void TCommonHistoryExport::SerializeToProto(NDrive::NProto::THistoryProcessorData& proto) const {
    proto.SetLastEventId(LastEventId);
}

bool TCommonHistoryExport::DeserializeFromProto(const NDrive::NProto::THistoryProcessorData& proto) {
    if (proto.HasLastEventId()) {
        LastEventId = proto.GetLastEventId();
    } else {
        LastEventId = Config.GetStartEventId();
    }
    return true;
}
