#pragma once

#include <drive/backend/background/manager/regular.h>

#include <drive/backend/abstract/frontend.h>
#include <drive/backend/proto/background.pb.h>

#include <rtline/util/types/accessor.h>


class TCommonHistoryExportConfig: public IBackgroundRegularProcessConfig {
public:
    using IBackgroundRegularProcessConfig::IBackgroundRegularProcessConfig;

    virtual void Init(const TYandexConfig::Section* section) override;
    virtual void ToString(IOutputStream& os) const override;

private:
    R_FIELD(TString, YtDataPath);
    R_FIELD(TString, YtCluster, "hahn");
    R_FIELD(ui32, ObjectsLimit, 10000);
    R_FIELD(ui32, StartEventId, 0);
};

class TCommonHistoryExport: public ISerializableProtoBackgroundProcess<NDrive::NProto::THistoryProcessorData, IBackgroundRegularProcessImpl<NDrive::IServer>> {
public:
    TCommonHistoryExport(const TCommonHistoryExportConfig& config);

    virtual void Stop() override {}
    virtual void Start() override {}

private:
    using TBase = ISerializableProtoBackgroundProcess<NDrive::NProto::THistoryProcessorData, IBackgroundRegularProcessImpl<NDrive::IServer>>;
    virtual void SerializeToProto(NDrive::NProto::THistoryProcessorData& proto) const override;
    virtual bool DeserializeFromProto(const NDrive::NProto::THistoryProcessorData& proto) override;

protected:
    const TCommonHistoryExportConfig& Config;
    mutable ui64 LastEventId = 0;
};

