#include "config.h"

#include "processor.h"

#include <rtline/util/algorithm/container.h>

#include <util/string/join.h>

TDBServiceConfig::TFactory::TRegistrator<TDBServiceConfig> TDBServiceConfig::Registrator("db_service");
TDBServiceConfig::TFactory::TRegistrator<TDBRegularServiceConfig> TDBRegularServiceConfig::Registrator("db_regular_service");

IBackgroundProcess* TDBServiceConfig::Construct() const {
    return new TDBServiceProcessor(this);
}

void TDBServiceConfig::Init(const TYandexConfig::Section* section) {
    IBackgroundRegularCarsProcessConfig::Init(section);
    Notifier = section->GetDirectives().Value("Notifier", Notifier);

    {
        TVector<TString> deadlyTagsVector;
        section->GetDirectives().FillArray("DeadlyTags", deadlyTagsVector);
        AssertCorrectConfig(deadlyTagsVector.size(), "Incorrect DeadlyTags for db_service configuration");
        DeadlyTags = MakeSet(deadlyTagsVector);
    }
    {
        TVector<TString> removedTagsVector;
        section->GetDirectives().FillArray("TagsToRemove", removedTagsVector);
        TagsToRemove = MakeSet(removedTagsVector);
    }
    {
        TVector<TString> taskTypesVector;
        section->GetDirectives().FillArray("BillingTaskTypes", taskTypesVector);
        BillingTaskTypes = MakeSet(taskTypesVector);
    }
    {
        TVector<TString> actionsVector;
        section->GetDirectives().FillArray("AccountActions", actionsVector);
        AccountActions = MakeSet(actionsVector);
    }
    {
        TVector<ui64> accountsVector;
        section->GetDirectives().TryFillArray("FastCleanAccountTypes", accountsVector);
        FastCleanAccountTypes = MakeSet(accountsVector);
    }

    TagHistoryLiveTime = section->GetDirectives().Value("TagHistoryLiveTime", TagHistoryLiveTime);
    AggressiveCarTagHistoryLiveTime = section->GetDirectives().Value("AggressiveCarTagHistoryLiveTime", AggressiveCarTagHistoryLiveTime);
    UserTagHistoryLiveTime = section->GetDirectives().Value("UserTagHistoryLiveTime", UserTagHistoryLiveTime);
    CompiledRidesLiveTime = section->GetDirectives().Value("CompiledRidesLiveTime", CompiledRidesLiveTime);
    CompiledBillsLiveTime = section->GetDirectives().Value("CompiledBillsLiveTime", CompiledBillsLiveTime);
    TraceTagHistoryLiveTime = section->GetDirectives().Value("TraceTagHistoryLiveTime", TraceTagHistoryLiveTime);
    CleanerDiscretizationRecordsCount = section->GetDirectives().Value("CleanerDiscretizationRecordsCount", CleanerDiscretizationRecordsCount);
    PauseBetweenRemoves = section->GetDirectives().Value("PauseBetweenRemoves", PauseBetweenRemoves);
    HeadSessionsHistoryLiveTime = section->GetDirectives().Value("HeadSessionsHistoryLiveTime", HeadSessionsHistoryLiveTime);
    DistributingBlockEventStatsHistoryLiveTime = section->GetDirectives().Value("DistributingBlockEventStatsHistoryLiveTime", DistributingBlockEventStatsHistoryLiveTime);
}

void TDBServiceConfig::ToString(IOutputStream& os) const {
    IBackgroundRegularCarsProcessConfig::ToString(os);
    os << "Notifier: " << Notifier << Endl;
    os << "DeadlyTags: " << JoinSeq(",", DeadlyTags) << Endl;
    os << "TagsToRemove: " << JoinSeq(",", TagsToRemove) << Endl;
    os << "BillingTaskTypes: " << JoinSeq(",", BillingTaskTypes) << Endl;
    os << "AccountActions: " << JoinSeq(",", AccountActions) << Endl;
    os << "AggressiveCarTagHistoryLiveTime: " << AggressiveCarTagHistoryLiveTime << Endl;
    os << "TraceTagHistoryLiveTime: " << TraceTagHistoryLiveTime << Endl;
    os << "UserTagHistoryLiveTime: " << UserTagHistoryLiveTime << Endl;
    os << "CompiledRidesLiveTime: " << CompiledRidesLiveTime << Endl;
    os << "CompiledBillsLiveTime: " << CompiledBillsLiveTime << Endl;
    os << "TagHistoryLiveTime: " << TagHistoryLiveTime << Endl;
    os << "CleanerDiscretizationRecordsCount: " << CleanerDiscretizationRecordsCount << Endl;
    os << "PauseBetweenRemoves: " << PauseBetweenRemoves << Endl;
    os << "HeadSessionsHistoryLiveTime: " << HeadSessionsHistoryLiveTime << Endl;
}

IBackgroundProcess* TDBRegularServiceConfig::Construct() const {
    return new TDBRegularServiceProcessor(this);
}

void TDBRegularServiceConfig::Init(const TYandexConfig::Section* section) {
    IBackgroundRegularCarsProcessConfig::Init(section);

    Notifier = section->GetDirectives().Value("Notifier", Notifier);
}

void TDBRegularServiceConfig::ToString(IOutputStream& os) const {
    IBackgroundRegularCarsProcessConfig::ToString(os);
    os << "Notifier: " << Notifier << Endl;
}
