#pragma once

#include <drive/backend/background/common/common.h>
#include <drive/backend/background/manager/regular.h>

#include <rtline/util/types/accessor.h>

class TDBServiceConfig: public IBackgroundRegularCarsProcessConfig {
    R_READONLY(TSet<TString>, DeadlyTags);
    R_READONLY(TSet<TString>, BillingTaskTypes);
    R_READONLY(TSet<TString>, AccountActions);
    R_READONLY(TSet<ui64>, FastCleanAccountTypes);

    R_READONLY(TDuration, TagHistoryLiveTime, TDuration::Days(180));
    R_READONLY(TDuration, AggressiveCarTagHistoryLiveTime, TDuration::Days(21));
    R_READONLY(TDuration, UserTagHistoryLiveTime, TDuration::Days(180));
    R_READONLY(TDuration, AggressiveUserTagHistoryLiveTime, TDuration::Days(14));
    R_READONLY(TDuration, CarTagPropositionsHistoryLiveTime, TDuration::Days(7));
    R_READONLY(TDuration, TraceTagHistoryLiveTime, TDuration::Days(180));
    R_READONLY(TDuration, AggressiveTraceTagHistoryLiveTime, TDuration::Days(7));
    R_READONLY(TDuration, UserDataHistoryLiveTime, TDuration::Days(60));
    R_READONLY(TDuration, UserDevicesHistoryLiveTime, TDuration::Days(365));
    R_READONLY(TDuration, CompiledRidesLiveTime, TDuration::Days(150));
    R_READONLY(TDuration, CompiledBillsLiveTime, TDuration::Days(300));
    R_READONLY(TDuration, ImagesHistoryLiveTime, TDuration::Days(180));
    R_READONLY(TDuration, InsuranceTasksLiveTime, TDuration::Days(90));
    R_READONLY(TDuration, BillingTasksLiveTime, TDuration::Days(90));
    R_READONLY(TDuration, PaymentsLiveTime, TDuration::Days(365));
    R_READONLY(TDuration, BillingAccountsLiveTime, TDuration::Days(90));
    R_READONLY(TDuration, FastAccountsLiveTime, TDuration::Days(30));
    R_READONLY(TDuration, DistributingBlockEventStatsHistoryLiveTime, TDuration::Days(30));

    R_READONLY(TSet<TString>, TagsToRemove);

    R_READONLY(TDuration, HeadSessionsHistoryLiveTime, TDuration::Days(90));
    R_READONLY(TString, Notifier);
    R_READONLY(ui32, CleanerDiscretizationRecordsCount, 500);
    R_READONLY(TDuration, PauseBetweenRemoves, TDuration::Seconds(1));

private:
    static TFactory::TRegistrator<TDBServiceConfig> Registrator;

public:
    using IBackgroundRegularCarsProcessConfig::IBackgroundRegularCarsProcessConfig;

    virtual IBackgroundProcess* Construct() const override;

    virtual void Init(const TYandexConfig::Section* section) override;
    virtual void ToString(IOutputStream& os) const override;
};

class TDBRegularServiceConfig: public IBackgroundRegularCarsProcessConfig {
    R_READONLY(TString, Notifier);

private:
    static TFactory::TRegistrator<TDBRegularServiceConfig> Registrator;

public:
    using IBackgroundRegularCarsProcessConfig::IBackgroundRegularCarsProcessConfig;

    virtual IBackgroundProcess* Construct() const override;

    virtual void Init(const TYandexConfig::Section* section) override;
    virtual void ToString(IOutputStream& os) const override;
};
