#pragma once
#include <drive/backend/background/manager/regular.h>

#include <drive/backend/abstract/frontend.h>

#include <rtline/library/unistat/signals.h>

class TDBServiceConfig;
class TDBRegularServiceConfig;

const TString HistoryEventIdColumn = "history_event_id";

class TDBServiceProcessor: public IBackgroundRegularProcessImpl<NDrive::IServer> {
private:
    using TBase = IBackgroundRegularProcessImpl<NDrive::IServer>;

    const TDBServiceConfig* Config = nullptr;

    void CleanHeadSessionsHistory(const NDrive::IServer* server) const;
    void CleanTagsHistory(const NDrive::IServer* server) const;
    void CleanTagsHistory(const TString& tagTable, const TString& tagHistoryTable, const TSet<TString>& tags, TDuration lifetime, const NDrive::IServer* server) const;
    void CleanDeprecatedTagsHistory(const NDrive::IServer* server) const;
    void CleanCarPropositionsHistory(const NDrive::IServer* server) const;
    void CleanUserDataHistory(const NDrive::IServer* server) const;
    void CleanCompiledRides(const NDrive::IServer* server) const;
    void CleanCompiledBills(const NDrive::IServer* server) const;
    void CleanImagesHistory(const NDrive::IServer* server) const;
    void CleanInsuranceTasksHistory(const NDrive::IServer* server) const;
    void CleanBillingTasksHistory(const NDrive::IServer* server) const;
    void CleanPayments(const NDrive::IServer* server) const;
    void CleanBillingAccountHistory(const NDrive::IServer* server) const;
    void CleanExpiredUserTemporaryActionTags(const NDrive::IServer* server) const;
    void CleanDistributingBlockEventStatsHistory(const NDrive::IServer* server) const;
    void RemoveCommon(const TString& query, const TString& target, const TInstant instantBorder, const NDrive::IServer* server, const TString& primaryKey = HistoryEventIdColumn) const;

    TMaybe<TVector<TString>> GetPerformedTagIds(const TString& tagTable, NDrive::TEntitySession& session) const;

public:
    TDBServiceProcessor(const TDBServiceConfig* config);

    virtual void Stop() override {}
    virtual void Start() override {}

protected:
    virtual bool DoExecuteImpl(TBackgroundProcessesManager* /*manager*/, IBackgroundProcess::TPtr /*self*/, const NDrive::IServer* server) const override;
};

class TDBRegularServiceProcessor: public IBackgroundRegularProcessImpl<NDrive::IServer> {
private:
    using TBase = IBackgroundRegularProcessImpl<NDrive::IServer>;

    const TDBRegularServiceConfig* Config = nullptr;

public:
    TDBRegularServiceProcessor(const TDBRegularServiceConfig* config);

    virtual void Stop() override {}
    virtual void Start() override {}

protected:
    virtual bool DoExecuteImpl(TBackgroundProcessesManager* /*manager*/, IBackgroundProcess::TPtr /*self*/, const NDrive::IServer* server) const override;
};
