#include "config.h"

#include "processor.h"

#include <util/string/join.h>

TUpdateOSAGOBackgroundProcessorConfig::TFactory::TRegistrator<TUpdateOSAGOBackgroundProcessorConfig> TUpdateOSAGOBackgroundProcessorConfig::Registrator("osago_updater");

void TUpdateOSAGOBackgroundProcessorConfig::ToString(IOutputStream& os) const {
    IBackgroundRegularCarsProcessConfig::ToString(os);
    os << "NotifierName: " << NotifierName << Endl;
    os << "UpdateTime: " << UpdateTime << Endl;
    os << "MdsBucket: " << MdsBucket << Endl;
    os << "DeliveryTagName: " << DeliveryTagName << Endl;
}

void TUpdateOSAGOBackgroundProcessorConfig::Init(const TYandexConfig::Section* section) {
    IBackgroundRegularCarsProcessConfig::Init(section);
    NotifierName = section->GetDirectives().Value("NotifierName", NotifierName);
    AssertCorrectConfig(!!NotifierName, "notifier undefined");
    UpdateTime = section->GetDirectives().Value("UpdateTime", UpdateTime);
    MdsBucket = section->GetDirectives().Value("MdsBucket", MdsBucket);
    AssertCorrectConfig(!!MdsBucket, "bucket undefined");
    DeliveryTagName = section->GetDirectives().Value("DeliveryTagName", DeliveryTagName);
}

IBackgroundProcess* TUpdateOSAGOBackgroundProcessorConfig::Construct() const {
    return new TUpdateOSAGOBackgroundProcessor(this);
}

TUpdateSTSBackgroundProcessorConfig::TFactory::TRegistrator<TUpdateSTSBackgroundProcessorConfig> TUpdateSTSBackgroundProcessorConfig::Registrator("sts_updater");

void TUpdateSTSBackgroundProcessorConfig::ToString(IOutputStream& os) const {
    IBackgroundRegularCarsProcessConfig::ToString(os);
    os << "NotifierName: " << NotifierName << Endl;
    os << "AbsentTag: " << AbsentTag << Endl;
    os << "DeliveryTag: " << DeliveryTag << Endl;
    os << "DeliveryStatus: " << DeliveryStatus << Endl;
    os << "NumberFieldName: " << NumberFieldName << Endl;
    os << "DateFieldName: " << DateFieldName << Endl;
    os << "NewRegNoFieldName: " << NewRegNoFieldName << Endl;
    os << "MdsBucket: " << MdsBucket << Endl;
    os << "<OsagoCarsFilter>" << Endl;
    OsagoCarsFilter.ToString(os);
    os << "</OsagoCarsFilter>" << Endl;
}

void TUpdateSTSBackgroundProcessorConfig::Init(const TYandexConfig::Section* section) {
    IBackgroundRegularCarsProcessConfig::Init(section);
    NotifierName = section->GetDirectives().Value("NotifierName", NotifierName);
    AssertCorrectConfig(!!NotifierName, "notifier undefined");
    AbsentTag = section->GetDirectives().Value("AbsentTag", AbsentTag);
    AssertCorrectConfig(!!AbsentTag, "absent tag undefined");
    DeliveryTag = section->GetDirectives().Value("DeliveryTag", DeliveryTag);
    AssertCorrectConfig(!!DeliveryTag, "delivery tag undefined");
    DeliveryStatus = section->GetDirectives().Value("DeliveryStatus", DeliveryStatus);
    NumberFieldName = section->GetDirectives().Value("NumberFieldName", NumberFieldName);
    DateFieldName = section->GetDirectives().Value("DateFieldName", DateFieldName);
    NewRegNoFieldName = section->GetDirectives().Value("NewRegNoFieldName", NewRegNoFieldName);
    MdsBucket = section->GetDirectives().Value("MdsBucket", MdsBucket);
    AssertCorrectConfig(!!MdsBucket, "bucket undefined");
    auto children = section->GetAllChildren();
    {
        auto it = children.find("OsagoCarsFilter");
        if (it != children.end()) {
            OsagoCarsFilter.Init(it->second);
        }
    }
}

IBackgroundProcess* TUpdateSTSBackgroundProcessorConfig::Construct() const {
    return new TUpdateSTSBackgroundProcessor(this);
}

TLoadSTSFromDiskBackgroundProcessorConfig::TFactory::TRegistrator<TLoadSTSFromDiskBackgroundProcessorConfig> TLoadSTSFromDiskBackgroundProcessorConfig::Registrator("load_sts_from_disk");
TLoadAPPFromDiskBackgroundProcessorConfig::TFactory::TRegistrator<TLoadAPPFromDiskBackgroundProcessorConfig> TLoadAPPFromDiskBackgroundProcessorConfig::Registrator("load_app_from_disk");
TLoadOSAGOFromDiskBackgroundProcessorConfig::TFactory::TRegistrator<TLoadOSAGOFromDiskBackgroundProcessorConfig> TLoadOSAGOFromDiskBackgroundProcessorConfig::Registrator("load_osago_from_disk");

void ILoadFromDiskBackgroundProcessorConfig::ToString(IOutputStream& os) const {
    IBackgroundRegularCarsProcessConfig::ToString(os);
    os << "NotifierName: " << NotifierName << Endl;
    os << "DiskPath: " << DiskPath << Endl;
    os << "MdsBucket: " << MdsBucket << Endl;
    os << "IgnoreExisting: " << IgnoreExisting << Endl;
}

void ILoadFromDiskBackgroundProcessorConfig::Init(const TYandexConfig::Section* section) {
    IBackgroundRegularCarsProcessConfig::Init(section);
    NotifierName = section->GetDirectives().Value("NotifierName", NotifierName);
    AssertCorrectConfig(!!NotifierName, "notifier undefined");
    DiskPath = section->GetDirectives().Value("DiskPath", DiskPath);
    MdsBucket = section->GetDirectives().Value("MdsBucket", MdsBucket);
    AssertCorrectConfig(!!MdsBucket, "bucket undefined");
    IgnoreExisting = section->GetDirectives().Value("IgnoreExisting", IgnoreExisting);
}

IBackgroundProcess* TLoadSTSFromDiskBackgroundProcessorConfig::Construct() const {
    return new TLoadSTSBackgroundProcessor(this);
}

IBackgroundProcess* TLoadAPPFromDiskBackgroundProcessorConfig::Construct() const {
    return new TLoadAPPBackgroundProcessor(this);
}

IBackgroundProcess* TLoadOSAGOFromDiskBackgroundProcessorConfig::Construct() const {
    return new TLoadOSAGOBackgroundProcessor(this);
}
