#pragma once

#include <drive/backend/background/common/common.h>
#include <drive/backend/background/manager/regular.h>

#include <rtline/util/types/accessor.h>

class TUpdateOSAGOBackgroundProcessorConfig : public IBackgroundRegularCarsProcessConfig {
    R_READONLY(TString, NotifierName);
    R_READONLY(TDuration, UpdateTime, TDuration::Days(7));
    R_READONLY(TString, MdsBucket);
    R_READONLY(TString, DeliveryTagName);

private:
    static TFactory::TRegistrator<TUpdateOSAGOBackgroundProcessorConfig> Registrator;

public:
    using IBackgroundRegularCarsProcessConfig::IBackgroundRegularCarsProcessConfig;

    virtual IBackgroundProcess* Construct() const override;

    virtual void ToString(IOutputStream& os) const override;
    virtual void Init(const TYandexConfig::Section* section) override;
};

class TUpdateSTSBackgroundProcessorConfig : public IBackgroundRegularCarsProcessConfig {
    R_READONLY(TString, NotifierName);
    R_READONLY(TString, AbsentTag);
    R_READONLY(TString, DeliveryTag);
    R_READONLY(TString, DeliveryStatus, "СТС готов к выдаче");
    R_READONLY(TString, NumberFieldName, "СТС");
    R_READONLY(TString, DateFieldName, "Дата СТС");
    R_READONLY(TString, NewRegNoFieldName, "Новый гос.номер");
    R_READONLY(TString, MdsBucket, "carsharing-car-documents");
    R_READONLY(TCarsFilter, OsagoCarsFilter);

private:
    static TFactory::TRegistrator<TUpdateSTSBackgroundProcessorConfig> Registrator;

public:
    using IBackgroundRegularCarsProcessConfig::IBackgroundRegularCarsProcessConfig;

    virtual IBackgroundProcess* Construct() const override;

    virtual void ToString(IOutputStream& os) const override;
    virtual void Init(const TYandexConfig::Section* section) override;
};

class ILoadFromDiskBackgroundProcessorConfig : public IBackgroundRegularCarsProcessConfig {
    R_READONLY(TString, NotifierName);
    R_READONLY(TString, DiskPath, "disk:/Автопарк/Документы");
    R_READONLY(TString, MdsBucket);
    R_READONLY(bool, IgnoreExisting, false);

public:
    virtual TString GetDocumentType() const = 0;
    using IBackgroundRegularCarsProcessConfig::IBackgroundRegularCarsProcessConfig;

    virtual void ToString(IOutputStream& os) const override;
    virtual void Init(const TYandexConfig::Section* section) override;
};

class TLoadSTSFromDiskBackgroundProcessorConfig : public ILoadFromDiskBackgroundProcessorConfig {
private:
    static TFactory::TRegistrator<TLoadSTSFromDiskBackgroundProcessorConfig> Registrator;

public:
    using ILoadFromDiskBackgroundProcessorConfig::ILoadFromDiskBackgroundProcessorConfig;

    virtual TString GetDocumentType() const override {
        return "STS";
    }

    virtual IBackgroundProcess* Construct() const override;
};

class TLoadAPPFromDiskBackgroundProcessorConfig : public ILoadFromDiskBackgroundProcessorConfig {
private:
    static TFactory::TRegistrator<TLoadAPPFromDiskBackgroundProcessorConfig> Registrator;

public:
    using ILoadFromDiskBackgroundProcessorConfig::ILoadFromDiskBackgroundProcessorConfig;

    virtual TString GetDocumentType() const override {
        return "APP";
    }

    virtual IBackgroundProcess* Construct() const override;
};

class TLoadOSAGOFromDiskBackgroundProcessorConfig : public ILoadFromDiskBackgroundProcessorConfig {
private:
    static TFactory::TRegistrator<TLoadOSAGOFromDiskBackgroundProcessorConfig> Registrator;

public:
    using ILoadFromDiskBackgroundProcessorConfig::ILoadFromDiskBackgroundProcessorConfig;

    virtual TString GetDocumentType() const override {
        return "OSAGO";
    }

    virtual IBackgroundProcess* Construct() const override;
};
