#pragma once
#include <drive/backend/background/manager/regular.h>

#include <drive/backend/cars/hardware.h>

class TUpdateOSAGOBackgroundProcessorConfig;

class TUpdateOSAGOBackgroundProcessor : public IBackgroundRegularProcessImpl<NDrive::IServer> {
private:
    using TBase = IBackgroundRegularProcessImpl<NDrive::IServer>;
    const TUpdateOSAGOBackgroundProcessorConfig* Config = nullptr;

public:
    TUpdateOSAGOBackgroundProcessor(const TUpdateOSAGOBackgroundProcessorConfig* config);

    virtual void Stop() override {}

    virtual void Start() override {}

protected:
    virtual bool DoExecuteImpl(TBackgroundProcessesManager* /*manager*/, IBackgroundProcess::TPtr /*self*/, const NDrive::IServer* server) const override;
};

class TUpdateSTSBackgroundProcessorConfig;

class TUpdateSTSBackgroundProcessor : public IBackgroundRegularProcessImpl<NDrive::IServer> {
private:
    using TBase = IBackgroundRegularProcessImpl<NDrive::IServer>;
    const TUpdateSTSBackgroundProcessorConfig* Config = nullptr;

public:
    TUpdateSTSBackgroundProcessor(const TUpdateSTSBackgroundProcessorConfig* config);

    virtual void Stop() override {}

    virtual void Start() override {}

protected:
    virtual bool DoExecuteImpl(TBackgroundProcessesManager* /*manager*/, IBackgroundProcess::TPtr /*self*/, const NDrive::IServer* server) const override;
};

class ILoadFromDiskBackgroundProcessorConfig;

class ILoadFromDiskBackgroundProcessor : public IBackgroundRegularProcessImpl<NDrive::IServer> {
private:
    using TBase = IBackgroundRegularProcessImpl<NDrive::IServer>;
    const ILoadFromDiskBackgroundProcessorConfig* Config = nullptr;

public:
    ILoadFromDiskBackgroundProcessor(const ILoadFromDiskBackgroundProcessorConfig* config);

    virtual void Stop() override {}

    virtual void Start() override {}

protected:
    virtual bool DoExecuteImpl(TBackgroundProcessesManager* /*manager*/, IBackgroundProcess::TPtr /*self*/, const NDrive::IServer* server) const override;

private:
    virtual bool CheckDocumentExistence(const TCarRegistryDocument& doc) const = 0;
    virtual void SetDocumentPath(TCarRegistryDocument& doc, const TString& path) const = 0;
};

class TLoadSTSBackgroundProcessor : public ILoadFromDiskBackgroundProcessor {
public:
    using ILoadFromDiskBackgroundProcessor::ILoadFromDiskBackgroundProcessor;
private:
    virtual bool CheckDocumentExistence(const TCarRegistryDocument& doc) const override {
        return !!doc.GetRegistrationMDSKey();
    }
    virtual void SetDocumentPath(TCarRegistryDocument& doc, const TString& path) const override {
        doc.SetRegistrationMDSKey(path);
    }
};

class TLoadAPPBackgroundProcessor : public ILoadFromDiskBackgroundProcessor {
public:
    using ILoadFromDiskBackgroundProcessor::ILoadFromDiskBackgroundProcessor;
private:
    virtual bool CheckDocumentExistence(const TCarRegistryDocument& doc) const override {
        return !!doc.GetMajorAppMDSKey();
    }
    virtual void SetDocumentPath(TCarRegistryDocument& doc, const TString& path) const override {
        doc.SetMajorAppMDSKey(path);
    }
};

class TLoadOSAGOBackgroundProcessor : public ILoadFromDiskBackgroundProcessor {
public:
    using ILoadFromDiskBackgroundProcessor::ILoadFromDiskBackgroundProcessor;
private:
    virtual bool CheckDocumentExistence(const TCarRegistryDocument& doc) const override {
        return !!doc.GetOsagoMDSKey();
    }
    virtual void SetDocumentPath(TCarRegistryDocument& doc, const TString& path) const override {
        doc.SetOsagoMDSKey(path);
    }
};
