#include "config.h"

#include "processor.h"

#include <util/string/join.h>

TUserFuelingConfig::TFactory::TRegistrator<TUserFuelingConfig> TUserFuelingConfig::Registrator("user_fueling");

IBackgroundProcess* TUserFuelingConfig::Construct() const {
    return new TUserFuelingProcessor(this);
}

TRegularFuelingReportConfig::TFactory::TRegistrator<TRegularFuelingReportConfig> TRegularFuelingReportConfig::Registrator("regular_fueling_report");

IBackgroundProcess* TRegularFuelingReportConfig::Construct() const {
    return new TRegularFuelingReportProcessor(this);
}

TServiceSessionsExportConfig::TFactory::TRegistrator<TServiceSessionsExportConfig> TServiceSessionsExportConfig::Registrator("fueling_export");

IBackgroundProcess* TServiceSessionsExportConfig::Construct() const {
    return new TFuelingSessionsExport(*this);
}

void TServiceSessionsExportConfig::Init(const TYandexConfig::Section* section) {
    TCommonHistoryExportConfig::Init(section);
    TString tagsTypes = section->GetDirectives().Value("TagsTypes", TString());
    StringSplitter(tagsTypes).Split(',').SkipEmpty().AddTo(&TagsTypes);
    section->GetDirectives().GetValue("NotifierName", NotifierName);

    const TYandexConfig::TSectionsMap children = section->GetAllChildren();
    auto tolokaIt = children.find("Toloka");
    if (tolokaIt != children.end()) {
        TolokaConfig = TTolokaClientConfig();
        TolokaConfig->Init(tolokaIt->second);
    }

    AssertCorrectConfig(!TagsTypes.empty(), "No tags configured");
}

void TServiceSessionsExportConfig::ToString(IOutputStream& os) const {
    TCommonHistoryExportConfig::ToString(os);
    os << "TagsTypes: " << JoinStrings(TagsTypes.begin(), TagsTypes.end(), ",") << Endl;
    os << "NotifierName: " << NotifierName << Endl;
    if (TolokaConfig.Defined()) {
        os << "<Toloka>" << Endl;
        TolokaConfig->ToString(os);
        os << "</Toloka>" << Endl;
    }
}
