#pragma once

#include <drive/backend/background/common/common.h>
#include <drive/backend/background/common/history.h>
#include <drive/backend/background/manager/regular.h>

#include <drive/library/cpp/toloka/client.h>

#include <rtline/util/types/accessor.h>

class TUserFuelingConfig: public IBackgroundRegularCarsProcessConfig {
private:
    static TFactory::TRegistrator<TUserFuelingConfig> Registrator;
    R_READONLY(TString, TagName);
public:
    using IBackgroundRegularCarsProcessConfig::IBackgroundRegularCarsProcessConfig;

    virtual IBackgroundProcess* Construct() const override;

    virtual void Init(const TYandexConfig::Section* section) override {
        IBackgroundRegularCarsProcessConfig::Init(section);
        TagName = section->GetDirectives().Value("TagName", TagName);
        AssertCorrectConfig(!!TagName, "Incorrect TagName field in TUserFuelingConfig");
    }

    virtual void ToString(IOutputStream& os) const override {
        os << "TagName: " << TagName << Endl;
    }
};

class TRegularFuelingReportConfig : public IBackgroundRegularProcessConfig {
private:
    static TFactory::TRegistrator<TRegularFuelingReportConfig> Registrator;
    R_READONLY(TString, NotifierName);
    R_READONLY(TString, Description);
public:
    using IBackgroundRegularProcessConfig::IBackgroundRegularProcessConfig;

    virtual IBackgroundProcess* Construct() const override;

    virtual void Init(const TYandexConfig::Section* section) override {
        IBackgroundRegularProcessConfig::Init(section);
        Description = section->GetDirectives().Value("Description", Description);
        AssertCorrectConfig(section->GetDirectives().GetValue("NotifierName", NotifierName), "no 'NotifierName' field");
    }

    virtual void ToString(IOutputStream& os) const override {
        IBackgroundRegularProcessConfig::ToString(os);
        os << "NotifierName: " << NotifierName << Endl;
        os << "Description: " << Description << Endl;
    }
};


class TServiceSessionsExportConfig: public TCommonHistoryExportConfig {
public:
    using TCommonHistoryExportConfig::TCommonHistoryExportConfig;
    virtual IBackgroundProcess* Construct() const override;

    virtual void Init(const TYandexConfig::Section* section) override;
    virtual void ToString(IOutputStream& os) const override;

    bool NeedInTolokaPools() const {
        return TolokaConfig.Defined();
    }

    const TTolokaClientConfig& GetTolokaConfig() const {
        return TolokaConfig.GetRef();
    }

private:
    static TFactory::TRegistrator<TServiceSessionsExportConfig> Registrator;
    R_READONLY(TSet<TString>, TagsTypes, {});
    R_READONLY(TString, NotifierName);
    TMaybe<TTolokaClientConfig> TolokaConfig;
};
