#pragma once
#include <drive/backend/background/common/history.h>
#include <drive/backend/background/manager/regular.h>

#include <rtline/library/unistat/signals.h>

class TUserFuelingConfig;
class TServiceSessionsExportConfig;

class TUserFuelingProcessor: public IBackgroundRegularProcessImpl<NDrive::IServer> {
private:
    using TBase = IBackgroundRegularProcessImpl<NDrive::IServer>;

    const TUserFuelingConfig* Config = nullptr;
public:
    TUserFuelingProcessor(const TUserFuelingConfig* config);

    virtual void Stop() override {}

    virtual void Start() override {}

protected:
    virtual bool DoExecuteImpl(TBackgroundProcessesManager* /*manager*/, IBackgroundProcess::TPtr /*self*/, const NDrive::IServer* server) const override;
};

class TRegularFuelingReportConfig;

class TRegularFuelingReportProcessor : public IBackgroundRegularProcessImpl<NDrive::IServer> {
private:
    using TBase = IBackgroundRegularProcessImpl<NDrive::IServer>;

    const TRegularFuelingReportConfig* Config = nullptr;
public:
    TRegularFuelingReportProcessor(const TRegularFuelingReportConfig* config);

    virtual void Stop() override {}
    virtual void Start() override {}

protected:
    virtual bool DoExecuteImpl(TBackgroundProcessesManager* /*manager*/, IBackgroundProcess::TPtr /*self*/, const NDrive::IServer* server) const override;
};


class TFuelingSessionsExport: public TCommonHistoryExport {
public:
    TFuelingSessionsExport(const TServiceSessionsExportConfig& config);
protected:
    virtual bool DoExecuteImpl(TBackgroundProcessesManager* /*manager*/, IBackgroundProcess::TPtr /*self*/, const NDrive::IServer* server) const;
private:
    using TBase = TCommonHistoryExport;
    const TServiceSessionsExportConfig& LocalConfig;
};

