#include "config.h"

#include "processor.h"

THeadRegularReportConfig::TFactory::TRegistrator<THeadRegularReportConfig> THeadRegularReportConfig::Registrator("head_regular_report");

IBackgroundProcess* THeadRegularReportConfig::Construct() const {
    return new THeadRegularReport(this);
}

void THeadRegularReportConfig::Init(const TYandexConfig::Section* section) {
    IBackgroundRegularProcessConfig::Init(section);
    Description = section->GetDirectives().Value("Description", Description);
    AssertCorrectConfig(section->GetDirectives().GetValue("NotifierName", NotifierName), "no 'NotifierName' field");
}

void THeadRegularReportConfig::ToString(IOutputStream& os) const {
    IBackgroundRegularProcessConfig::ToString(os);
    os << "NotifierName: " << NotifierName << Endl;
    os << "Description: " << Description << Endl;
}
