#include "processor.h"

#include "config.h"

#include <drive/backend/abstract/base.h>
#include <drive/backend/cars/car.h>
#include <drive/backend/cars/status/state_filters.h>
#include <drive/backend/database/drive_api.h>
#include <drive/backend/head/head_account.h>

bool THeadRegularReport::DoExecuteImpl(TBackgroundProcessesManager* /*manager*/, IBackgroundProcess::TPtr /*self*/, const NDrive::IServer* server) const {
    TMap<TString, TString> headIds;
    if (!server->GetDriveAPI()->GetHeadAccountManager().GetHeadIds({}, headIds)) {
        ERROR_LOG << "failed to get headIds" << Endl;
        return true;
    }
    auto gCars = server->GetDriveAPI()->GetCarsData()->FetchInfo();
    auto statuses = server->GetDriveAPI()->GetStateFiltersDB()->GetObjectStates();
    TStringStream csvReport;
    csvReport << "vin;number;model;status;head id" << Endl;
    for (const auto& car : gCars.GetResult()) {
        auto headIt = headIds.find(car.first);
        if (headIt != headIds.end()) {
            auto statusIt = statuses.find(car.first);
            csvReport << car.second.GetVin() << ";"
                << car.second.GetNumber() << ";"
                << car.second.GetModel() << ";"
                << ((statusIt != statuses.end()) ? statusIt->second : "unknown") << ";"
                << headIt->second << Endl;
        }
    }
    TString stringDay = ToString(TInstant::Now()).substr(0, 10);
    NDrive::INotifier::TMessage message(stringDay, csvReport.Str());
    message.SetAdditionalInfo(Config->GetDescription());
    message.SetTitle(stringDay + ".csv");

    if (!NDrive::INotifier::SendDocument(server->GetNotifier(Config->GetNotifierName()), message, "text/csv", NDrive::INotifier::TContext().SetServer(server))) {
        ERROR_LOG << "Notifier internal error" << Endl;
    }
    return true;
}

THeadRegularReport::THeadRegularReport(const THeadRegularReportConfig* config)
    : TBase(*config)
    , Config(config)
{
}
