#pragma once

#include <drive/backend/background/common/common.h>

#include <rtline/util/types/accessor.h>

class THeadTagWatcherConfig: public IBackgroundRegularProcessConfig {
    R_READONLY(TString, TagName);

private:
    static TFactory::TRegistrator<THeadTagWatcherConfig> Registrator;

public:
    using IBackgroundRegularProcessConfig::IBackgroundRegularProcessConfig;

    virtual IBackgroundProcess* Construct() const override;

    virtual void Init(const TYandexConfig::Section* section) override {
        IBackgroundRegularProcessConfig::Init(section);
        TagName = section->GetDirectives().Value("TagName", TagName);
    }

    virtual void ToString(IOutputStream& os) const override {
        IBackgroundRegularProcessConfig::ToString(os);
        os << "TagName: " << TagName << Endl;
    }
};
