#pragma once
#include <drive/backend/background/manager/regular.h>

#include <drive/backend/abstract/frontend.h>

#include <rtline/library/unistat/signals.h>

class THeadTagWatcherConfig;
class TDBTag;

class THeadTagWatcher: public IBackgroundRegularProcessImpl<NDrive::IServer> {
private:
    using TBase = IBackgroundRegularProcessImpl<NDrive::IServer>;

    const THeadTagWatcherConfig* Config = nullptr;
    mutable TSignalByKey<TString, double> EmptySignal;
    mutable TSignalByKey<TString, double> AddSignal;
    mutable TSignalByKey<TString, double> RemoveSignal;

public:
    THeadTagWatcher(const THeadTagWatcherConfig* config);

    virtual void Stop() override {}

    virtual void Start() override {}

    static TString TagName;

private:
    void UpdateSignalMap(const NDrive::IServer* server) const;
    bool CheckHeads(const NDrive::IServer* server) const;
    bool GetHeadTags(const NDrive::IServer* server, TMap<TString, TDBTag>& result) const;

protected:
    virtual bool DoExecuteImpl(TBackgroundProcessesManager* /*manager*/, IBackgroundProcess::TPtr /*self*/, const NDrive::IServer* server) const override;
};
