#include "config.h"

#include "processor.h"

#include <util/string/join.h>

TMajorRequesterConfig::TFactory::TRegistrator<TMajorRequesterConfig> TMajorRequesterConfig::Registrator("major_requester");

IBackgroundProcess* TMajorRequesterConfig::Construct() const {
    return new TMajorRequester(this);
}

void TMajorRequesterConfig::Init(const TYandexConfig::Section* section) {
    IBackgroundRegularCarsProcessConfig::Init(section);
    AssertCorrectConfig(section->GetDirectives().TryFillArray<TString, char, false>("TagNames", TagNames), "empty list of tag names");
    MaxAge = section->GetDirectives().Value<TDuration>("MaxAge", MaxAge);
    NotifierName = section->GetDirectives().Value("NotifierName", NotifierName);
    FailedCriticalLimit = section->GetDirectives().Value("FailedCriticalLimit", FailedCriticalLimit);
    RemoveWithPerformer = section->GetDirectives().Value("RemoveWithPerformer", RemoveWithPerformer);
    CancelCommentName = section->GetDirectives().Value("CancelCommentName", CancelCommentName);
    CancelStatus = section->GetDirectives().Value("CancelStatus", CancelStatus);
}

void TMajorRequesterConfig::ToString(IOutputStream& os) const {
    IBackgroundRegularCarsProcessConfig::ToString(os);
    os << "TagNames: " << JoinSeq(",", TagNames) << Endl;
    os << "MaxAge: " << MaxAge << Endl;
    os << "NotifierName: " << NotifierName << Endl;
    os << "FailedCriticalLimit: " << FailedCriticalLimit << Endl;
    os << "RemoveWithPerformer: " << RemoveWithPerformer << Endl;
    os << "CancelCommentName: " << CancelCommentName << Endl;
    os << "CancelStatus: " << CancelStatus << Endl;
}
