#pragma once
#include <drive/backend/background/common/common.h>
#include <drive/backend/background/manager/regular.h>

#include <rtline/util/types/accessor.h>

class TMajorRequesterConfig : public IBackgroundRegularCarsProcessConfig {

private:
    static TFactory::TRegistrator<TMajorRequesterConfig> Registrator;
    R_READONLY(TVector<TString>, TagNames, {});
    R_READONLY(TDuration, MaxAge, TDuration::Minutes(1));
    R_READONLY(TString, NotifierName);
    R_READONLY(ui32, FailedCriticalLimit, 5);
    R_READONLY(bool, RemoveWithPerformer, false);
    R_READONLY(TString, CancelCommentName);
    R_READONLY(TString, CancelStatus);

public:
    using IBackgroundRegularCarsProcessConfig::IBackgroundRegularCarsProcessConfig;

    TMajorRequesterConfig(const TString& type, const TString& id, const TVector<TString>& tagNames)
        : IBackgroundRegularCarsProcessConfig(type, id)
        , TagNames(tagNames)
    {}

    virtual IBackgroundProcess* Construct() const override;

    virtual void Init(const TYandexConfig::Section* section) override;
    virtual void ToString(IOutputStream& os) const override;
};
