#pragma once

#include <drive/backend/background/manager/regular.h>

#include <drive/backend/database/drive_api.h>
#include <drive/backend/major/client.h>
#include <drive/backend/proto/background.pb.h>

#include <rtline/library/unistat/signals.h>

class TMajorRequesterConfig;

enum EMajorRequestStatus {
    Accept,
    Reject,
};

class TMajorRequester: public ISerializableProtoBackgroundProcess<NDrive::NProto::TMajorRequester, IBackgroundRegularProcessImpl<NDrive::IServer>> {
private:
    using TBase = ISerializableProtoBackgroundProcess<NDrive::NProto::TMajorRequester, IBackgroundRegularProcessImpl<NDrive::IServer>>;

    const TMajorRequesterConfig* Config = nullptr;
    TEnumSignal<EMajorRequestStatus> CreateSignal;
    TEnumSignal<EMajorRequestStatus> CancelSignal;
    TEnumSignal<NMajorClient::EWorkType> WorkTypeSignal;
    TUnistatSignal<double> IncorrectWorkTypeSignal;

    TMap<TString, ui32> PreviousFailedCars;
    mutable TMap<TString, ui32> CurrentFailedCars;

protected:
    bool DoExecuteImpl(TBackgroundProcessesManager* /*manager*/, IBackgroundProcess::TPtr /*self*/, const NDrive::IServer* server) const override;
    virtual void SerializeToProto(NDrive::NProto::TMajorRequester& proto) const override;
    virtual bool DeserializeFromProto(const NDrive::NProto::TMajorRequester& proto) override;

public:
    TMajorRequester(const TMajorRequesterConfig* config);
    bool SendRequests(const NDrive::IServer* server) const;
    virtual void Stop() override {}

    virtual void Start() override {}

private:
    void SendFailedCarNotifications(const NDrive::IServer* server) const;
    void AddFailedCar(const TString& carId) const;
    bool HasCriticalSendLimit(const TString& carId) const;
    bool IsFailedCar(const TString& carId) const;
};
