#include "manager.h"
#include <library/cpp/mediator/global_notifications/system_status.h>
#include <library/cpp/logger/global/global.h>

void TBackgroundProcessesManagerConfig::Init(const TYandexConfig::Section* section) {
    ThreadsCount = section->GetDirectives().Value("ThreadsCount", ThreadsCount);
    auto sections = section->GetAllChildren();
    auto it = sections.find("Processes");
    if (it != sections.end()) {
        const TYandexConfig::Section* sectionProcesses = it->second;
        auto processes = sectionProcesses->GetAllChildren();
        for (auto&& i : processes) {
            TString type;
            AssertCorrectConfig(i.second->GetDirectives().GetValue("Type", type), "No type field in regular processes section");
            Generators.push_back(IBackgroundProcessConfig::TFactory::Construct(type, type, i.first));
            AssertCorrectConfig(!!Generators.back(), "Incorrect type in regular processes section: %s", type.data());
            Generators.back()->Init(i.second);
        }
    }
}

void TBackgroundProcessesManagerConfig::ToString(IOutputStream& os) const {
    os << "ThreadsCount: " << ThreadsCount << Endl;
    os << "<Processes>" << Endl;
    for (auto&& i : Generators) {
        os << "<" << i->GetId() << ">" << Endl;
        os << "Type: " << i->GetType() << Endl;
        i->ToString(os);
        os << "</" << i->GetId() << ">" << Endl;
    }
    os << "</Processes>" << Endl;
}

void TBackgroundProcessesManager::RegisterProcess(IBackgroundProcessConfig* processGenerator) {
    if (Scheduler) {
        const TString& id = processGenerator->GetId();
        CHECK_WITH_LOG(!Processes.contains(id));
        IBackgroundProcess::TPtr process = processGenerator->Construct();
        process->Start();
        Processes[id] = process;
        Scheduler->Schedule(new TScheduledItem(process, process->GetStartInstant(), this));
    }
}
