#include "regular.h"
#include "manager.h"
#include <library/cpp/logger/global/global.h>
#include <util/string/join.h>
#include <rtline/util/algorithm/container.h>
#include <util/generic/cast.h>


void IBackgroundRegularProcessConfig::Init(const TYandexConfig::Section* section) {
    IBackgroundProcessConfig::Init(section);
    Period = section->GetDirectives().Value<TDuration>("Period", Period);
    DryRunMode = section->GetDirectives().Value("DryRunMode", DryRunMode);
    TVector<ui16> times;
    const TString tt = section->GetDirectives().Value<TString>("Timetable", "");
    AssertCorrectConfig(section->GetDirectives().TryFillArray("Timetable", times), "Incorrect background process timetable: %s", tt.data());
    Timetable = MakeSet(times);
}

void IBackgroundRegularProcessConfig::ToString(IOutputStream& os) const {
    IBackgroundProcessConfig::ToString(os);
    os << "Period: " << Period << Endl;
    os << "DryRunMode: " << DryRunMode << Endl;
    os << "Timetable: " << JoinSeq(",", Timetable) << Endl;
}

TInstant IBackgroundRegularProcessConfig::GetNextCallInstant(const TInstant lastCallInstant) const {
    if (Timetable.size()) {
        ui16 time = lastCallInstant.Minutes() % 60;
        time += (lastCallInstant.Hours() % 24) * 100;
        DEBUG_LOG << time << Endl;
        TMaybe<TInstant> result;
        for (auto&& i : Timetable) {
            if (i > time) {
                result = TInstant::Days(lastCallInstant.Days()) + TDuration::Hours(i / 100) + TDuration::Minutes(i % 100);
                break;
            }
        }
        if (!result) {
            result = TInstant::Days(lastCallInstant.Days() + 1) + TDuration::Hours(*Timetable.begin() / 100) + TDuration::Minutes(*Timetable.begin() % 100);
        }
        DEBUG_LOG << result->Seconds() << Endl;
        return Max(Now(), *result);
    } else {
        return lastCallInstant + GetPeriod();
    }
}
