#include "config.h"

#include "processor.h"

#include <util/string/join.h>

TNoTagsWatcherConfig::TFactory::TRegistrator<TNoTagsWatcherConfig> TNoTagsWatcherConfig::Registrator("no_tags_corrector");

IBackgroundProcess* TNoTagsWatcherConfig::Construct() const {
    return new TNoTagsWatcher(this);
}

void TNoTagsWatcherConfig::Init(const TYandexConfig::Section* section) {
    IBackgroundRegularProcessConfig::Init(section);
    NotifierName = section->GetDirectives().Value("NotifierName", NotifierName);
    TagName = section->GetDirectives().Value("TagName", TagName);
    AssertCorrectConfig(!!TagName, "Incorrect TagName in NoTagsWatcherConfig");
}

void TNoTagsWatcherConfig::ToString(IOutputStream& os) const {
    IBackgroundRegularProcessConfig::ToString(os);
    os << "NotifierName: " << NotifierName << Endl;
    os << "TagName: " << TagName << Endl;
}
