#pragma once
#include <drive/backend/background/manager/regular.h>

#include <drive/backend/abstract/frontend.h>
#include <drive/backend/data/proto/alerts.pb.h>

class TNoTagsWatcherConfig;

class TNoTagsWatcher: public ISerializableProtoBackgroundProcess<NDrive::NProto::TDeviceProblemsState, IBackgroundRegularProcessImpl<NDrive::IServer>> {
private:
    using TBase = ISerializableProtoBackgroundProcess<NDrive::NProto::TDeviceProblemsState, IBackgroundRegularProcessImpl<NDrive::IServer>>;

    virtual void SerializeToProto(NDrive::NProto::TDeviceProblemsState& proto) const override;
    virtual bool DeserializeFromProto(const NDrive::NProto::TDeviceProblemsState& proto) override;

    const TNoTagsWatcherConfig* Config = nullptr;

protected:


    bool DoExecuteImpl(TBackgroundProcessesManager* /*manager*/, IBackgroundProcess::TPtr /*self*/, const NDrive::IServer* server) const override;
public:
    TNoTagsWatcher(const TNoTagsWatcherConfig* config);

    virtual void Stop() override {
    }

    virtual void Start() override {
    }

};
