#pragma once

#include <drive/backend/background/manager/regular.h>

#include <rtline/library/time_restriction/time_restriction.h>

#include <drive/library/cpp/parking/api/client.h>
#include <drive/library/cpp/parking/inhouse/client.h>

class TParkingPaymentWatcherConfig: public IBackgroundRegularProcessConfig {
public:
    using TTimetable = TTimeRestrictionsPool<TTimeRestriction>;

public:
    using IBackgroundRegularProcessConfig::IBackgroundRegularProcessConfig;

    const TMap<TString, TString>& GetTokenGroups() const {
        return TokenGroups;
    }
    const TSet<TString>& GetNonParkableStatuses() const {
        return NonParkableStatuses;
    }
    const TSet<TString>& GetIncludedModels() const {
        return IncludedModels;
    }
    const TSet<TString>& GetExcludedModels() const {
        return ExcludedModels;
    }
    const TString& GetApplicationId() const {
        return ApplicationId;
    }
    const TString& GetNotifier() const {
        return Notifier;
    }
    const TString& GetGeoObjectsHost() const {
        return GeoObjectsHost;
    }
    const TString& GetGeoObjectsService() const {
        return GeoObjectsService;
    }
    ui16 GetGeoObjectsPost() const {
        return GeoObjectsPort;
    }
    const TString& GetKznClientToken() const {
        return KznClientToken;
    }
    const TString& GetMskClientToken() const {
        return MskClientToken;
    }
    const TString& GetSpbClientToken() const {
        return SpbClientToken;
    }
    const TString& GetTagName() const {
        return TagName;
    }
    const TString& GetTracksApiName() const {
        return TracksApiName;
    }
    TDuration GetTracksApiTimeout() const {
        return TracksApiTimeout;
    }
    const TTimetable& GetTariffTimetable() const {
        return TariffTimetable;
    }
    TDuration GetIdleDuration() const {
        return IdleDuration;
    }
    TDuration GetQuantum() const {
        return Quantum;
    }
    bool IsDryRun() const {
        return DryRun;
    }
    bool ShouldNotifySuccess() const {
        return NotifySuccess;
    }
    const NDrive::TMskParkingPaymentConfig* GetMskParkingConfig() const {
        return MskParkingConfig.Get();
    }
    ui64 GetSwitchMskAggregatorId() const {
        return SwitchMskAggregatorId;
    }

    virtual IBackgroundProcess* Construct() const override;

    virtual void Init(const TYandexConfig::Section* section) override;
    virtual void ToString(IOutputStream& os) const override;

private:
    TMap<TString, TString> TokenGroups;
    TString TokenGroupsFile;
    TSet<TString> NonParkableStatuses = {
        "old_state_riding",
        "ride"
    };
    TSet<TString> IncludedModels;
    TSet<TString> ExcludedModels;
    TString ApplicationId;
    TString Notifier;
    TString GeoObjectsHost = "saas-searchproxy-maps.yandex.net";
    TString GeoObjectsService = "drive_router";
    TString KznClientToken;
    TString MskClientToken;
    TString SpbClientToken;
    TString TagName;
    TString TracksApiName;
    TDuration TracksApiTimeout = TDuration::MilliSeconds(100);
    ui16 GeoObjectsPort = 17000;
    TTimetable TariffTimetable;
    TDuration IdleDuration = TDuration::Minutes(3);
    TDuration Quantum = TDuration::Hours(1);
    bool DryRun = false;
    bool NotifySuccess = false;
    THolder<NDrive::TMskParkingPaymentConfig> MskParkingConfig;
    ui64 SwitchMskAggregatorId = NDrive::TParkingListClient::MskAggregatorId;
};

class TParkingBalanceWatcherConfig: public IBackgroundRegularProcessConfig {
public:
    using IBackgroundRegularProcessConfig::IBackgroundRegularProcessConfig;

    const TString& GetCertificateFile() const {
        return CertificateFile;
    }
    const TString& GetPrivateKeyFile() const {
        return PrivateKeyFile;
    }
    const TString& GetPrivateKeyPassword() const {
        return PrivateKeyPassword;
    }
    const TString& GetWalletsFile() const {
        return WalletsFile;
    }

    const TString& GetAgentId() const {
        return AgentId;
    }
    const TString& GetApplicationId() const {
        return ApplicationId;
    }
    const TString& GetShopId() const {
        return ShopId;
    }
    const TString& GetShopArticleId() const {
        return ShopArticleId;
    }
    const TSet<TString>& GetWallets() const {
        return Wallets;
    }

    const TString& GetKznClientToken() const {
        return KznClientToken;
    }
    const TString& GetSpbClientToken() const {
        return SpbClientToken;
    }
    const TString& GetNotifier() const {
        return Notifier;
    }
    double GetThreshold() const {
        return Threshold;
    }

    double GetPaymentAmount() const {
        return PaymentAmount;
    }
    double GetWalletThreshold() const {
        return WalletThreshold;
    }
    bool PaymentsEnabled() const {
        return AgentId && ApplicationId && ShopId && ShopArticleId;
    }

    virtual IBackgroundProcess* Construct() const override;

    virtual void Init(const TYandexConfig::Section* section) override;
    virtual void ToString(IOutputStream& os) const override;

private:
    TString CertificateFile;
    TString PrivateKeyFile;
    TString PrivateKeyPassword;
    TString WalletsFile;

    TString AgentId;
    TString ApplicationId;
    TString ShopId;
    TString ShopArticleId;
    TSet<TString> Wallets;

    TString KznClientToken;
    TString SpbClientToken;

    TString Notifier;

    double Threshold = 2500;
    double PaymentAmount = 200;
    double WalletThreshold = 4000;
};
