#pragma once

#include <drive/backend/background/manager/regular.h>

#include <drive/backend/abstract/frontend.h>
#include <drive/backend/proto/background.pb.h>

#include <drive/library/cpp/parking/api/client.h>

class TParkingPaymentWatcherConfig;
class TParkingBalanceWatcherConfig;

class TParkingPaymentWatcher: public IBackgroundRegularProcessImpl<NDrive::IServer> {
public:
    enum EIdleStatus {
        Unknown /* "unknown" */,
        IsIdle /* "is_idle" */,
        SensorSpeed /* "sensor_speed" */,
        TailSpeed /* "tail_speed" */,
        EmptyTail /* "empty_tail" */,
        ConfigError /* "config_error" */,
        Exception /* "exception" */,
        Timeout /* "timeout" */,
    };

public:
    TParkingPaymentWatcher(const TParkingPaymentWatcherConfig& config);

    virtual void Start() override {}
    virtual void Stop() override {}

protected:
    bool DoExecuteImpl(TBackgroundProcessesManager* manager, IBackgroundProcess::TPtr self, const NDrive::IServer* server) const override;

private:
    template <class TLocatorAPI>
    THolder<TLocatorAPI> CreateLocator(const TString& token) const;

    const TString& GetTokenGroup(const TString& token) const;
    EIdleStatus GetIdleStatus(const TString& id, const NDrive::IServer* server) const;

private:
    const TParkingPaymentWatcherConfig& Config;

    NDrive::TFitDevParkingPaymentClient KznClient;
    NDrive::TMosParkingPaymentClient MskClient;
    NDrive::TSpbParkingPaymentClient SpbClient;
    THolder<NDrive::TMskParkingPaymentClient> MskParkingClient;
};

class TParkingBalanceWatcher: public ISerializableProtoBackgroundProcess<NDrive::NProto::TParkingBalanceData, IBackgroundRegularProcessImpl<NDrive::IServer>> {
private:
    using TBase = ISerializableProtoBackgroundProcess<NDrive::NProto::TParkingBalanceData, IBackgroundRegularProcessImpl<NDrive::IServer>>;

public:
    TParkingBalanceWatcher(const TParkingBalanceWatcherConfig& config);

    virtual void Start() override {}
    virtual void Stop() override {}

protected:
    virtual bool DoExecuteImpl(TBackgroundProcessesManager* manager, IBackgroundProcess::TPtr self, const NDrive::IServer* server) const override;

    virtual void SerializeToProto(NDrive::NProto::TParkingBalanceData& proto) const override;
    virtual bool DeserializeFromProto(const NDrive::NProto::TParkingBalanceData& proto) override;

    TString GetWallet() const;
    void NextWallet() const;
    void UseWallet(double amount) const;
    void MakeBalanceNotification(double balance, const TString& segment, const NDrive::IServer& server) const;

private:
    const TParkingBalanceWatcherConfig& Config;

    mutable TString ActiveWallet;
    mutable double ActiveSpent;
};
