#include "config.h"

#include "processor.h"

#include <rtline/util/algorithm/container.h>

#include <util/string/join.h>

TNewAutoRegularReportConfig::TFactory::TRegistrator<TNewAutoRegularReportConfig> TNewAutoRegularReportConfig::Registrator("new_auto_regular_report");

IBackgroundProcess* TNewAutoRegularReportConfig::Construct() const {
    return new TNewAutoRegularReport(this);
}

void TNewAutoRegularReportConfig::Init(const TYandexConfig::Section* section) {
    IBackgroundRegularCarsProcessConfig::Init(section);
    Description = section->GetDirectives().Value("Description", Description);
    AssertCorrectConfig(section->GetDirectives().GetValue("NotifierName", NotifierName), "no 'NotifierName' field");
    section->GetDirectives().FillArray("AdditionalTags", AdditionalTags);
}

void TNewAutoRegularReportConfig::ToString(IOutputStream& os) const {
    IBackgroundRegularCarsProcessConfig::ToString(os);
    os << "NotifierName: " << NotifierName << Endl;
    os << "Description: " << Description << Endl;
    os << "AdditionalTags: " << JoinSeq(",", AdditionalTags) << Endl;
}

TCleaningRegularReportConfig::TFactory::TRegistrator<TCleaningRegularReportConfig> TCleaningRegularReportConfig::Registrator("cleaning_regular_report");

IBackgroundProcess* TCleaningRegularReportConfig::Construct() const {
    return new TCleaningRegularReport(this);
}

void TCleaningRegularReportConfig::Init(const TYandexConfig::Section* section) {
    IBackgroundRegularCarsProcessConfig::Init(section);
    AssertCorrectConfig(section->GetDirectives().GetValue("NotifierName", NotifierName), "no 'NotifierName' field");
    TString tags = section->GetDirectives().Value("Tags", JoinSeq(",", Tags));
    StringSplitter(tags).Split(',').SkipEmpty().AddTo(&Tags);
    AssertCorrectConfig(!Tags.empty(), "\"Tags\" field empty");

    TString roles = section->GetDirectives().Value("Roles", JoinSeq(",", Roles));
    StringSplitter(roles).Split(',').SkipEmpty().AddTo(&Roles);

    TVector<TString> departments;
    section->GetDirectives().FillArray("Departments", departments);
    Departments = MakeSet(departments);

    StartEventId = section->GetDirectives().Value("StartEventId", StartEventId);
    StartIndex = section->GetDirectives().Value("StartIndex", StartIndex);
    AssertCorrectConfig(section->GetDirectives().GetValue("BucketName", BucketName), "no 'BucketName' field");
    PhotoDelay = section->GetDirectives().Value<TDuration>("PhotoDelay", PhotoDelay);
    MaxSessionsCount = section->GetDirectives().Value("MaxSessionsCount", MaxSessionsCount);
}

void TCleaningRegularReportConfig::ToString(IOutputStream& os) const {
    IBackgroundRegularCarsProcessConfig::ToString(os);
    os << "NotifierName: " << NotifierName << Endl;
    os << "Tags: " << JoinSeq(",", Tags) << Endl;
    os << "Roles: " << JoinSeq(",", Roles) << Endl;
    os << "Departments: " << JoinSeq(",", Departments) << Endl;
    os << "StartEventId: " << StartEventId << Endl;
    os << "StartIndex: " << StartIndex << Endl;
    os << "BucketName: " << BucketName << Endl;
    os << "PhotoDelay: " << PhotoDelay << Endl;
    os << "MaxSessionsCount: " << MaxSessionsCount << Endl;
}
