#pragma once
#include <drive/backend/background/common/common.h>
#include <drive/backend/background/manager/regular.h>

#include <rtline/util/types/accessor.h>

class TNewAutoRegularReportConfig : public IBackgroundRegularCarsProcessConfig {
private:
    static TFactory::TRegistrator<TNewAutoRegularReportConfig> Registrator;
    R_READONLY(TString, NotifierName);
    R_READONLY(TString, Description);
    R_READONLY(TVector<TString>, AdditionalTags, {});
public:
    using IBackgroundRegularCarsProcessConfig::IBackgroundRegularCarsProcessConfig;

    virtual IBackgroundProcess* Construct() const override;

    virtual void Init(const TYandexConfig::Section* section) override;
    virtual void ToString(IOutputStream& os) const override;
};

class TCleaningRegularReportConfig : public IBackgroundRegularCarsProcessConfig {
private:
    static TFactory::TRegistrator<TCleaningRegularReportConfig> Registrator;
    R_READONLY(TString, NotifierName);
    R_READONLY(TSet<TString>, Tags, {});
    R_READONLY(TSet<TString>, Roles, {});
    R_READONLY(TSet<TString>, Departments);
    R_READONLY(ui64, StartEventId, 0);
    R_READONLY(ui64, StartIndex, 0);
    R_READONLY(TString, BucketName);
    R_READONLY(ui32, MaxSessionsCount, 30);
    R_READONLY(TDuration, PhotoDelay, TDuration::Minutes(15));

public:
    using IBackgroundRegularCarsProcessConfig::IBackgroundRegularCarsProcessConfig;

    virtual IBackgroundProcess* Construct() const override;

    virtual void Init(const TYandexConfig::Section* section) override;
    virtual void ToString(IOutputStream& os) const override;
};
