#pragma once

#include <drive/backend/background/manager/regular.h>

#include <drive/backend/abstract/frontend.h>
#include <drive/backend/proto/background.pb.h>

class TNewAutoRegularReportConfig;

class TNewAutoRegularReport : public IBackgroundRegularProcessImpl<NDrive::IServer> {
private:
    using TBase = IBackgroundRegularProcessImpl<NDrive::IServer>;
    const TNewAutoRegularReportConfig* Config = nullptr;

protected:
    bool DoExecuteImpl(TBackgroundProcessesManager* /*manager*/, IBackgroundProcess::TPtr /*self*/, const NDrive::IServer* server) const override;
public:
    TNewAutoRegularReport(const TNewAutoRegularReportConfig* config);

    virtual void Stop() override {
    }

    virtual void Start() override {
    }

};

class TCleaningRegularReportConfig;

class TCleaningRegularReport : public ISerializableProtoBackgroundProcess<NDrive::NProto::TCleaningReport, IBackgroundRegularProcessImpl<NDrive::IServer>> {
private:
    using TBase = ISerializableProtoBackgroundProcess<NDrive::NProto::TCleaningReport, IBackgroundRegularProcessImpl<NDrive::IServer>>;
    const TCleaningRegularReportConfig* Config = nullptr;
    mutable ui64 LastEventId = 0;
    mutable ui64 LastSuccessfulTaskId = 0;

protected:
    bool DoExecuteImpl(TBackgroundProcessesManager* /*manager*/, IBackgroundProcess::TPtr /*self*/, const NDrive::IServer* server) const override;
    virtual void SerializeToProto(NDrive::NProto::TCleaningReport& proto) const override;
    virtual bool DeserializeFromProto(const NDrive::NProto::TCleaningReport& proto) override;

public:
    TCleaningRegularReport(const TCleaningRegularReportConfig* config);

    virtual void Stop() override {}
    virtual void Start() override {}
};
