#include "config.h"

#include "processor.h"

TRentPricingWatcherConfig::TFactory::TRegistrator<TRentPricingWatcherConfig> TRentPricingWatcherConfig::Registrator("rent_pricing_watcher");

IBackgroundProcess* TRentPricingWatcherConfig::Construct() const {
    return new TRentPricingWatcher(this);
}

void TRentPricingWatcherConfig::Init(const TYandexConfig::Section* section) {
    IBackgroundRegularProcessConfig::Init(section);
    NotifierName = section->GetDirectives().Value("NotifierName", NotifierName);
}

void TRentPricingWatcherConfig::ToString(IOutputStream& os) const {
    IBackgroundRegularProcessConfig::ToString(os);
    if (!!NotifierName) {
        os << "NotifierName: " << NotifierName << Endl;
    }
}
