#pragma once
#include <drive/backend/background/rent_pricing/proto/rent_pricing.pb.h>

#include <drive/backend/background/manager/regular.h>

#include <drive/backend/abstract/frontend.h>

#include <rtline/util/instant_model.h>

class TRentPricingWatcherConfig;

class TRentPricingWatcher: public ISerializableProtoBackgroundProcess<NRentPricingProto::TState, IBackgroundRegularProcessImpl<NDrive::IServer>> {
private:
    mutable TInstant LastPriceCalculated = ModelingNow();
    using TBase = ISerializableProtoBackgroundProcess<NRentPricingProto::TState, IBackgroundRegularProcessImpl<NDrive::IServer>>;

    virtual void SerializeToProto(NRentPricingProto::TState& proto) const override;
    virtual bool DeserializeFromProto(const NRentPricingProto::TState& proto) override;

    const TRentPricingWatcherConfig* Config = nullptr;

protected:
    bool DoExecuteImpl(TBackgroundProcessesManager* /*manager*/, IBackgroundProcess::TPtr /*self*/, const NDrive::IServer* server) const override;

public:
    TRentPricingWatcher(const TRentPricingWatcherConfig* config);

    virtual void Stop() override {
    }

    virtual void Start() override {
    }
};
