#pragma once

#include <drive/backend/background/manager/regular.h>

#include <drive/backend/database/drive_api.h>
#include <drive/backend/database/drive/takeout.h>

#include <rtline/library/async_proxy/async_delivery.h>
#include <rtline/util/network/neh.h>

class TTakeoutRegularConfig: public IBackgroundRegularProcessConfig {
private:
    R_READONLY(TString, NotifierName);
    R_READONLY(TString, TracksAPIName);
    R_READONLY(ui32, RequestsLimit, 50);

    static TFactory::TRegistrator<TTakeoutRegularConfig> Registrator;

public:
    using IBackgroundRegularProcessConfig::IBackgroundRegularProcessConfig;

    virtual IBackgroundProcess* Construct() const override;

    virtual void Init(const TYandexConfig::Section* section) override {
        IBackgroundRegularProcessConfig::Init(section);
        NotifierName = section->GetDirectives().Value("NotifierName", NotifierName);
        TracksAPIName = section->GetDirectives().Value("TracksAPIName", TracksAPIName);
        RequestsLimit = section->GetDirectives().Value("RequestsLimit", RequestsLimit);
    }

    virtual void ToString(IOutputStream& os) const override {
        IBackgroundRegularProcessConfig::ToString(os);
        if (NotifierName) {
            os << "NotifierName: " << NotifierName << Endl;
        }
        if (TracksAPIName) {
            os << "TracksAPIName: " << TracksAPIName << Endl;
        }
        os << "RequestsLimit: " << RequestsLimit << Endl;
    }
};

class TTakeoutRegular: public IBackgroundRegularProcessImpl<NDrive::IServer> {
private:
    using TBase = IBackgroundRegularProcessImpl<NDrive::IServer>;
    const TTakeoutRegularConfig* Config = nullptr;

protected:
    bool DoExecuteImpl(TBackgroundProcessesManager* /*manager*/, IBackgroundProcess::TPtr /*self*/, const NDrive::IServer* server) const override;

    virtual bool DequeueRequest(const NDrive::IServer* server, TTakeoutRequest& request, const TString& jobId, const TVector<TString>& filenames, TVector<TString>& errorMessages) const;

public:
    TTakeoutRegular(const TTakeoutRegularConfig* config)
        : TBase(*config)
        , Config(config)
    {
    }

    virtual void Stop() override {
    }

    virtual void Start() override {
    }
};
