#include "telegram.h"

#include <drive/backend/database/drive_api.h>
#include <drive/backend/users/login.h>

IChatTelegramCommandsProcessor::IChatTelegramCommandsProcessor(TActiveTelegramBot* bot)
    : ITelegramCommandsProcessor(bot)
    , processedOk(Bot->GetId(), EBotCommandStatus::Ok)
    , processedBadUser(Bot->GetId(), EBotCommandStatus::BadUser)
    , processedBadCommand(Bot->GetId(), EBotCommandStatus::BadCommand)
{
}

void IChatTelegramCommandsProcessor::Execute(const NJson::TJsonValue& message, const IServerBase* server) {
    if (!message.Has("message") || !message["message"].Has("chat") || !message["message"]["chat"].Has("id")) {
        ERROR_LOG << "Invalid telegram message format" << Endl;
        return;
    }

    const TString chatId = message["message"]["chat"]["id"].GetStringRobust();

    const TString username = message["message"]["from"]["username"].GetStringRobust();
    TString userId;
    if (!server->GetAsPtrSafe<NDrive::IServer>()->GetDriveAPI()->GetLoginsManager()->GetUserIdByLogin(ELoginType::Telegram, username, "", Now() - TDuration::Minutes(1), userId)) {
        ERROR_LOG << "Cannot receive user info: " << username << Endl;
        return;
    }
    if (!userId) {
        ERROR_LOG << "Unknown user: " << username << Endl;
        if (!!Bot) {
            Bot->Notify(NDrive::INotifier::TMessage("Unknown user: " + username), chatId);
        }
        processedBadUser.Signal(1);
        return;
    }

    const TBotCommands commands = ExtractBotCommands(message["message"]);

    for (auto&& command : commands) {
        if (ProcessCommand(command, chatId, server)) {
            processedOk.Signal(1);
            return;
        }
    }
    processedBadCommand.Signal(1);
}

