#pragma once
#include <drive/backend/background/manager/regular.h>
#include <drive/backend/background/telegram_bot/telegram.h>
#include <drive/backend/background/telegram_bot/proto/telegram.pb.h>

#include <drive/backend/abstract/notifier.h>
#include <drive/backend/notifications/telegram/telegram.h>

#include <library/cpp/yconf/conf.h>

#include <rtline/library/metasearch/simple/config.h>
#include <rtline/library/unistat/signals.h>
#include <rtline/util/types/accessor.h>

#include <util/generic/ptr.h>
#include <util/stream/output.h>

class IChatTelegramCommandsProcessor : public ITelegramCommandsProcessor {
protected:
    TTelegramBotCommandSignal processedOk;
    TTelegramBotCommandSignal processedBadUser;
    TTelegramBotCommandSignal processedBadCommand;

public:
    IChatTelegramCommandsProcessor(TActiveTelegramBot* bot);

    void Execute(const NJson::TJsonValue& message, const IServerBase* server) override;

    virtual bool ProcessCommand(const TBotCommand& command, const TString& chatId, const IServerBase* server) = 0;
};
