#include "echo_bot.h"

#include <drive/backend/notifications/telegram/telegram.h>

void TEchoTelegramProcessor::Execute(const NJson::TJsonValue& message, const IServerBase* /*server*/) {
    Bot->Notify(NDrive::INotifier::TMessage(message["message"]["text"].GetStringRobust()), message["message"]["chat"]["id"].GetStringRobust());
}

ITelegramCommandsProcessor* TEchoProcessorConfig::Construct(TActiveTelegramBot* bot) const {
    return new TEchoTelegramProcessor(*this, bot);
}

TEchoProcessorConfig::TFactory::TRegistrator<TEchoProcessorConfig> TEchoProcessorConfig::Registrator("echo");
