#include "config.h"

#include "processor.h"

#include <util/string/join.h>

IBackgroundProcess* TTelematicsConfigurationWatcherConfig::Construct() const {
    return new TTelematicsConfigurationWatcher(*this);
}

void TTelematicsConfigurationWatcherConfig::Init(const TYandexConfig::Section* section) {
    IBackgroundRegularProcessConfig::Init(section);
    const TYandexConfig::Directives& d = Yensured(section)->GetDirectives();
    DefaultPasswordTag = d.Value("DefaultPasswordTag", DefaultPasswordTag);
    DisableTag = d.Value("DisableTag", DisableTag);
    FilterStatus = d.Value("FilterStatus", FilterStatus);
    StringSplitter(
        d.Value("CarStatusBlacklist", JoinSeq(",", CarStatusBlacklist))
    ).SplitBySet(" ,").SkipEmpty().ParseInto(&CarStatusBlacklist);
}

void TTelematicsConfigurationWatcherConfig::ToString(IOutputStream& os) const {
    IBackgroundRegularProcessConfig::ToString(os);
    os << "DefaultPasswordTag: " << DefaultPasswordTag << Endl;
    os << "DisableTag: " << DisableTag << Endl;
    os << "FilterStatus: " << FilterStatus << Endl;
    os << "CarStatusBlacklist" << JoinSeq(",", CarStatusBlacklist) << Endl;
}

IBackgroundProcess* TTelematicsFirmwareWatcherConfig::Construct() const {
    return new TTelematicsFirmwareWatcher(*this);
}

void TTelematicsFirmwareWatcherConfig::Init(const TYandexConfig::Section* section) {
    IBackgroundRegularProcessConfig::Init(section);
    const TYandexConfig::Directives directives = Yensured(section)->GetDirectives();
    RequiredSensorFreshness = directives.Value("RequiredSensorFreshness", RequiredSensorFreshness);
    UpdateTimeout = directives.Value("UpdateTimeout", UpdateTimeout);
    ReupdateDelay = directives.Value("ReupdateDelay", ReupdateDelay);
}

void TTelematicsFirmwareWatcherConfig::ToString(IOutputStream& os) const {
    IBackgroundRegularProcessConfig::ToString(os);
    os << "RequiredSensorFreshness: " << RequiredSensorFreshness << Endl;
    os << "UpdateTimeout: " << UpdateTimeout << Endl;
    os << "ReupdateDelay: " << ReupdateDelay << Endl;
}

IBackgroundRegularProcessConfig::TFactory::TRegistrator<TTelematicsConfigurationWatcherConfig> TelematicsConfigurationWatcher("telematics_configuration");
IBackgroundRegularProcessConfig::TFactory::TRegistrator<TTelematicsFirmwareWatcherConfig> TelematicsFirmwareWatcher("telematics_firmware");
