#pragma once

#include <drive/backend/background/common/common.h>
#include <drive/backend/background/manager/regular.h>

#include <drive/telematics/protocol/settings.h>

class TTelematicsConfigurationWatcherConfig: public IBackgroundRegularProcessConfig {
public:
    using IBackgroundRegularProcessConfig::IBackgroundRegularProcessConfig;

    virtual IBackgroundProcess* Construct() const override;
    virtual void Init(const TYandexConfig::Section* section) override;
    virtual void ToString(IOutputStream& os) const override;

    const TString& GetDefaultPasswordTag() const {
        return DefaultPasswordTag;
    }
    const TString& GetDisableTag() const {
        return DisableTag;
    }
    const TString& GetFilterStatus() const {
        return FilterStatus;
    }
    TDuration GetMaximumDuration() const {
        return MaximumDuration;
    }
    TDuration GetTelematicsTimeout() const {
        return TelematicsTimeout;
    }

private:
    TString DefaultPasswordTag = "new_car";
    TString DisableTag = "disable_telematics_configuration";
    TString FilterStatus;
    TDuration MaximumDuration = TDuration::Hours(1);
    TDuration TelematicsTimeout = TDuration::Seconds(10);
    R_READONLY(TSet<TString>, CarStatusBlacklist);
};

class TTelematicsFirmwareWatcherConfig : public IBackgroundRegularProcessConfig {
public:
    using IBackgroundRegularProcessConfig::IBackgroundRegularProcessConfig;

    const TSet<TString>& GetRequiredStatuses() const {
        return RequiredStatuses;
    }
    TDuration GetRequiredSensorFreshness() const {
        return RequiredSensorFreshness;
    }
    TDuration GetUpdateTimeout() const {
        return UpdateTimeout;
    }
    TDuration GetReupdateDelay() const {
        return ReupdateDelay;
    }

    virtual IBackgroundProcess* Construct() const override;
    virtual void Init(const TYandexConfig::Section* section) override;
    virtual void ToString(IOutputStream& os) const override;

private:
    TSet<TString> RequiredStatuses = {
        "available",
        "drive_team_access",
        "hidden",
        "new",
        "service",
        "engine_off"
    };
    TDuration RequiredSensorFreshness = TDuration::Minutes(1);
    TDuration UpdateTimeout = TDuration::Seconds(100);
    TDuration ReupdateDelay = TDuration::Hours(12);
};

