#pragma once

#include <drive/backend/abstract/frontend.h>

#include <drive/backend/background/manager/regular.h>

#include <drive/backend/data/telematics.h>

class TDriveCarInfo;
class TTelematicsConfigurationWatcherConfig;
class TTelematicsFirmwareWatcherConfig;
class TTelematicsCanConfigurationWatcherConfig;

class TTelematicsConfigurationWatcher: public IBackgroundRegularProcessImpl<NDrive::IServer> {
public:
    TTelematicsConfigurationWatcher(const TTelematicsConfigurationWatcherConfig& config);

    virtual void Start() override;
    virtual void Stop() override;

protected:
    bool DoExecuteImpl(TBackgroundProcessesManager* manager, IBackgroundProcess::TPtr self, const NDrive::IServer* server) const override;

private:
    void Apply(const TDriveCarInfo& device, const NDrive::IServer* server, const TString& robotUserId) const;

private:
    const TTelematicsConfigurationWatcherConfig& Config;
};

class TTelematicsFirmwareWatcher : public IBackgroundRegularProcessImpl<NDrive::IServer> {
public:
    class TUpdater {
    public:
        TUpdater(const TString& id, const NDrive::IServer& server, const TString& robotUserId)
            : Id(id)
            , Server(server)
            , RobotUserId(robotUserId)
        {
        }

        TString GetId() const {
            return Id;
        }

        void Init(const TVector<TTaggedDevice>& devices);
        NDrive::NVega::TFirmwareInfo GetCurrent(const TDBTag& tag) const;
        NDrive::NVega::TFirmwareInfo GetDesired(const TTaggedDevice& object, const TDriveCarInfo* deviceInfo, const NDrive::NVega::TFirmwareInfo& firmwareInfo) const;
        bool UpdateTagInfo(const TDBTag& tag, const NDrive::NVega::TFirmwareInfo& info, const TString& handler, const TInstant lastUpdate = TInstant::Zero()) const;

    private:
        struct TUpdatedInfo {
            ui64 Total = 0;
            ui64 Updated = 0;
        };

    private:
        TString Id;
        const NDrive::IServer& Server;
        TString RobotUserId;
        mutable TMap<TTelematicsFirmwareTag::TDescription::TFirmwareInfo, TUpdatedInfo> UpdatedInfo;

    private:
        TVector<TTelematicsFirmwareTag::TDescription::TFirmwareInfo> GetFirmwares(const TTaggedObject& object, const TDriveCarInfo* deviceInfo, const NDrive::NVega::TFirmwareInfo& firmwareInfo) const;
    };

public:
    TTelematicsFirmwareWatcher(const TTelematicsFirmwareWatcherConfig& config);

    virtual void Start() override {
    }
    virtual void Stop() override {
    }

protected:
    bool DoExecuteImpl(TBackgroundProcessesManager* manager, IBackgroundProcess::TPtr self, const NDrive::IServer* server) const override;

private:
    const TTelematicsFirmwareWatcherConfig& Config;
};

