#pragma once

#include <drive/backend/background/manager/regular.h>

#include <drive/backend/abstract/frontend.h>

namespace NDrive {
    class TEntitySession;
}

class TTransformationWatcherConfig;

class TTransformationWatcher: public IBackgroundRegularProcessImpl<NDrive::IServer> {
public:
    TTransformationWatcher(const TTransformationWatcherConfig& config);

    using IBackgroundProcess::Execute;
    bool RestoreTransformations(TBackgroundProcessesManager* manager, IBackgroundProcess::TPtr self, const NDrive::IServer* server) const;

    virtual void Start() override {}
    virtual void Stop() override {}

protected:
    bool DoExecuteImpl(TBackgroundProcessesManager* manager, IBackgroundProcess::TPtr self, const NDrive::IServer* server) const override;

private:
    const TTransformationWatcherConfig& Config;
};
