#pragma once

#include "config.h"

#include <drive/library/cpp/searchserver/client.h>
#include <drive/library/cpp/searchserver/replier.h>

class TSimpleHttpReplyContext: public TCommonHttpReplyContext<TServerRequestData> {
private:
    using TBase = TCommonHttpReplyContext<TServerRequestData>;
    using TBase::Client;
public:
    using TRequestData = TServerRequestData;
    using TBase::TBase;

    virtual const TCgiParameters& GetCgiParameters() const override {
        return Client->GetRequestData().CgiParam;
    }

    virtual TCgiParameters& MutableCgiParameters() override {
        return Client->MutableRequestData().CgiParam;
    }

    virtual TStringBuf GetUri() const override {
        return Client->GetRequestData().ScriptName();
    }

    virtual TServerRequestData& MutableRequestData() override {
        return Client->MutableRequestData();
    }

    virtual const TServerRequestData& GetRequestData() const override {
        return Client->MutableRequestData();
    }
};

class TBaseClientRequest: public THttpClientImpl<TSimpleHttpReplyContext> {
private:
    const TServerBaseConfig* Config;
    const IServerBase* Server;

protected:
    virtual IHttpReplier::TPtr DoSelectHandler(IReplyContext::TPtr context) override;

public:
    TBaseClientRequest(const TServerBaseConfig* config, const IServerBase* server);
};
