#pragma once

#include "client.h"

#include <drive/library/cpp/searchserver/server.h>

class IServerBase;

class TBaseHttpServer: public TSearchServerAbstract<TServerBaseConfig> {
private:
    using TBase = TSearchServerAbstract<TServerBaseConfig>;

private:
    const TServerBaseConfig* Config;
    const IServerBase* Server;

public:
    TBaseHttpServer(const TServerBaseConfig& config, const IServerBase* server)
        : TBase(config)
        , Config(&config)
        , Server(server)
    {
    }

    virtual TClientRequest* CreateClient() override {
        return new TBaseClientRequest(Config, Server);
    }
};
