#pragma once

#include "server.h"

#include <drive/library/cpp/searchserver/replier.h>

class TReplier: public IHttpReplier {
private:
    class THandlersCounterGuard {
    private:
        const TString Key;
    public:
        THandlersCounterGuard(const TString& key, const TString& metric);
        ~THandlersCounterGuard();
    };

private:
    const TServerBaseConfig* Config;
    const IServerBase* Server;
    IRequestProcessor::TPtr Processor;
    TVersionedKey Key;
    THolder<THandlersCounterGuard> SignalGuard;

public:
    TReplier(IReplyContext::TPtr context, const TServerBaseConfig* config, const IServerBase* server);
    ~TReplier();

    virtual TDuration GetDefaultTimeout() const;
    virtual void OnRequestExpired();
    virtual void DoSearchAndReply();
    virtual IThreadPool* DoSelectHandler();
};
