#pragma once

#include <drive/backend/billing/interfaces/account.h>

namespace NDrive::NBilling {
    class TBonusAccountRecordImpl: public TAccountRecord {
        R_FIELD(ui64, Balance, 0);
        R_FIELD(TLimitedBalances, LimitedBalances);
    public:
        TBonusAccountRecordImpl() = default;
        bool ParseMeta(const NJson::TJsonValue& meta) override;
        void SaveMeta(NJson::TJsonValue& meta) const override;
        virtual NDrive::TScheme DoGetScheme(const NDrive::IServer* /*server*/) const override;
    };

    template <class TRecord, EWalletDataType WalletDataType>
    class TBonusAccountImpl: public IBillingAccount {
    public:
        using IBillingAccount::IBillingAccount;
        i64 GetBalance() const override;
        virtual TLimitedBalances GetLimitedBalanceBySum(ui32 sum) const override;
        virtual TInstant GetNextRefresh() const override;

        virtual EPaymentGroupType GetGroupType() const override {
            return EPaymentGroupType::Radio;
        }

    protected:
        EDriveOpResult DoAdd(ui32 sum, NDrive::TEntitySession& session, TInstant deadline = TInstant::Max(), const TString& source = {}) const override;
        EDriveOpResult DoRemove(ui32 sum, NDrive::TEntitySession& session) const override;
        virtual bool DoRefresh(TAccountRecord::TPtr record) const override;
    };

    class TBonusAccountRecord: public TBonusAccountRecordImpl {
    public:
        virtual EAccount GetAccountType() const {
            return EAccount::Bonus;
        }
    private:
        static TFactory::TRegistrator<TBonusAccountRecord> Registrator;
    };

    class TCoinsAccountRecord: public TBonusAccountRecordImpl {
    public:
        virtual EAccount GetAccountType() const {
            return EAccount::Coins;
        }
    private:
        static TFactory::TRegistrator<TCoinsAccountRecord> Registrator;
    };

    class TBonusAccount: public TBonusAccountImpl<TBonusAccountRecord, EWalletDataType::Bonus> {
        using TBase = TBonusAccountImpl<TBonusAccountRecord, EWalletDataType::Bonus>;
    public:
        using TBase::TBase;
    private:
        static TFactory::TRegistrator<TBonusAccount> Registrator;
    };

    class TCoinsAccount: public TBonusAccountImpl<TCoinsAccountRecord, EWalletDataType::Coins> {
        using TBase = TBonusAccountImpl<TCoinsAccountRecord, EWalletDataType::Coins>;
    public:
        using TBase::TBase;
    private:
        static TFactory::TRegistrator<TCoinsAccount> Registrator;
    };

    NJson::TJsonValue GetBonusPaymethodUserReport(ELocalization locale, const IServerBase& server, const IBillingAccount::TReportContext& context);
}
