#include "mobile_payment.h"

namespace NDrive::NBilling {
    TAccountRecord::TFactory::TRegistrator<TMobilePaymentAccountRecord> TMobilePaymentAccountRecord::Registrator(EWalletDataType::MobilePayment);
    IBillingAccount::TFactory::TRegistrator<TMobilePaymentAccount> TMobilePaymentAccount::Registrator(EAccount::MobilePayment);

    NJson::TJsonValue TMobilePaymentAccount::GetNewUserReport(ELocalization locale, const IServerBase& server, const TVector<IBillingAccount::TPtr>& userAccounts, const IBillingAccount::TReportContext& context) const {
        auto result = IBillingAccount::GetNewUserReport(locale, server, userAccounts, context);
        if (context.System) {
            if (auto local = server.GetLocalization()) {
                result["name"] = local->GetLocalString(locale, "mobile_payment_system." + *context.System, *context.System);
            }
            auto icon = server.GetSettings().GetJsonValue("billing.system_icons")[*context.System].GetString();
            if (icon) {
                result["icon"] = icon;
            }
        }
        return result;
    }
}
