#pragma once

#include <drive/backend/billing/interfaces/account.h>
#include <drive/backend/billing/interfaces/entities.h>

namespace NDrive::NBilling {

    class TMobilePaymentAccountRecord: public TAccountRecord {
        virtual NDrive::TScheme DoGetScheme(const NDrive::IServer* /*server*/) const {
            NDrive::TScheme result;
            return result;
        }
        virtual EAccount GetAccountType() const {
            return EAccount::MobilePayment;
        }

    private:
        static TFactory::TRegistrator<TMobilePaymentAccountRecord> Registrator;
    };

    class TMobilePaymentAccount: public IBillingAccount {
    public:
        using IBillingAccount::IBillingAccount;

        i64 GetBalance() const override {
            return 0;
        };
        virtual EPaymentGroupType GetGroupType() const override {
            return EPaymentGroupType::Radio;
        }

        NJson::TJsonValue GetNewUserReport(ELocalization locale, const IServerBase& server, const TVector<IBillingAccount::TPtr>& userAccounts, const IBillingAccount::TReportContext& context) const override;

    protected:
        virtual EDriveOpResult DoAdd(ui32 /*sum*/, NDrive::TEntitySession& /*session*/, TInstant /*deadline*/, const TString& /*source*/) const override {
            return EDriveOpResult::LogicError;
        }
        virtual EDriveOpResult DoRemove(ui32 /*sum*/, NDrive::TEntitySession& /*session*/) const override {
            return EDriveOpResult::LogicError;
        }

    private:
        static TFactory::TRegistrator<TMobilePaymentAccount> Registrator;
    };

}
