#pragma once

#include "limited.h"

#include <drive/backend/billing/interfaces/account.h>


namespace NDrive::NBilling {

    class TSalaryAccountRecord : public TLimitedAccountRecord {
        using TBase = TLimitedAccountRecord;

        R_FIELD(TString, ClientId);
        R_FIELD(TString, ContractId);
    public:
        TSalaryAccountRecord() = default;

        bool ParseMeta(const NJson::TJsonValue& meta) override {
            PatchMeta(meta);
            return TBase::ParseMeta(meta);
        }

        bool PatchMeta(const NJson::TJsonValue& meta) override {
            if (meta.Has("client_id")) {
                ClientId = meta["client_id"].GetString();
                ui32 tmp = 0;
                if (!!ClientId && !TryFromString(ClientId, tmp)) {
                    return false;
                }
            }
            if (meta.Has("contract_id")) {
                ContractId = meta["contract_id"].GetString();
                if (!ContractId.empty() && !ContractId.StartsWith("РАС-") /*rus*/ && !ContractId.StartsWith("PAC-") /*eng*/) {
                    return false;
                }
            }
            return TBase::PatchMeta(meta);
        }

        void SaveMeta(NJson::TJsonValue& meta) const override {
            TBase::SaveMeta(meta);
            meta["client_id"] = ClientId;
            meta["contract_id"] = ContractId;
        }

        virtual NDrive::TScheme DoGetScheme(const NDrive::IServer* server) const override {
            NDrive::TScheme result = TBase::DoGetScheme(server);
            result.Add<TFSString>("client_id", "ID клиента в Балансе");
            result.Add<TFSString>("contract_id", "Номер договора (РАС-*)");
            return result;
        }

    private:
        static TFactory::TRegistrator<TSalaryAccountRecord> Registrator;
    };

}
