#pragma once

#include <drive/backend/billing/interfaces/account.h>
#include <drive/backend/billing/interfaces/entities.h>

namespace NDrive::NBilling {

    class TTrustAccountRecord: public TAccountRecord {
        R_FIELD(TString, DefaultCard, 0);
        R_FIELD(ui32, PanPrefix, 0);
        R_FIELD(ui32, PanSuffix, 0);
    public:
        virtual bool ParseMeta(const NJson::TJsonValue& meta) override;
        virtual void SaveMeta(NJson::TJsonValue& meta) const override;
        virtual NDrive::TScheme DoGetScheme(const NDrive::IServer* server) const override;
        virtual NJson::TJsonValue GetReport() const override;
        EAccount GetAccountType() const override {
            return EAccount::Trust;
        }

        TString GetSuffixString() const;
    private:
        static TFactory::TRegistrator<TTrustAccountRecord> Registrator;
    };

    class TTrustAccount: public IBillingAccount, public ITrustAccount {
    public:
        using IBillingAccount::IBillingAccount;

        i64 GetBalance() const override;
        TString GetDefaultCard() const override;
        bool SetDefaultCard(const NDrive::NTrustClient::TPaymentMethod& defaultCard, const TString& historyUser, NDrive::TEntitySession& session) override;
        virtual NJson::TJsonValue GetUserReport() const override;

    protected:
        virtual EDriveOpResult DoAdd(ui32 /*sum*/, NDrive::TEntitySession& /*session*/, TInstant /*deadline*/, const TString& /*source*/) const override {
            return EDriveOpResult::LogicError;
        }
        virtual EDriveOpResult DoRemove(ui32 /*sum*/, NDrive::TEntitySession& /*session*/) const override {
            return EDriveOpResult::LogicError;
        }

    private:
        static TFactory::TRegistrator<TTrustAccount> Registrator;
    };

}
