#pragma once

#include <drive/backend/billing/interfaces/account.h>
#include <drive/backend/billing/interfaces/entities.h>

namespace NDrive::NBilling {

    class TYandexAccountRecord: public TAccountRecord {
        R_FIELD(TString, PaymethodId);
    public:
        virtual bool ParseMeta(const NJson::TJsonValue& meta) override;
        virtual bool PatchMeta(const NJson::TJsonValue& meta) override;
        virtual void SaveMeta(NJson::TJsonValue& meta) const override;
        virtual NDrive::TScheme DoGetScheme(const NDrive::IServer* server) const override;
        virtual NJson::TJsonValue GetReport() const override;
        EAccount GetAccountType() const override {
            return EAccount::YAccount;
        }

    private:
        static TFactory::TRegistrator<TYandexAccountRecord> Registrator;
    };

    class TYandexAccount: public IBillingAccount {
    public:
        using IBillingAccount::IBillingAccount;

        i64 GetBalance() const override;
        virtual EPaymentGroupType GetGroupType() const override {
            return EPaymentGroupType::Switch;
        }

        virtual NJson::TJsonValue GetNewUserReport(ELocalization locale, const IServerBase& server, const TVector<IBillingAccount::TPtr>& userAccounts, const IBillingAccount::TReportContext& context) const override;

    protected:
        virtual EDriveOpResult DoAdd(ui32 /*sum*/, NDrive::TEntitySession& /*session*/, TInstant /*deadline*/, const TString& /*source*/) const override {
            return EDriveOpResult::LogicError;
        }
        virtual EDriveOpResult DoRemove(ui32 /*sum*/, NDrive::TEntitySession& /*session*/) const override {
            return EDriveOpResult::LogicError;
        }

    private:
        static TFactory::TRegistrator<TYandexAccount> Registrator;
    };

    class TFakeYandexAccount: public TYandexAccount {
    public:
        using TYandexAccount::TYandexAccount;

        virtual NJson::TJsonValue GetNewUserReport(ELocalization locale, const IServerBase& server, const TVector<IBillingAccount::TPtr>& userAccounts, const IBillingAccount::TReportContext& context) const override;

        TString GetName() const override {
            return "Поехать дешевле";
        }

        virtual EPaymentGroupType GetGroupType() const override {
            return EPaymentGroupType::Link;
        }
    };
}
