#pragma once

#include <drive/backend/billing/interfaces/logic.h>

class TBonusPaymentMeta : public IPaymentMeta {
    R_READONLY(NDrive::NBilling::TLimitedBalances, LimitedBonuses);
public:
    TBonusPaymentMeta() = default;
    TBonusPaymentMeta(NDrive::NBilling::TLimitedBalances&& limitedBonuses)
        : IPaymentMeta()
        , LimitedBonuses(limitedBonuses)
    {}
    virtual bool Parse(const NJson::TJsonValue& json) override {
        return !json.IsDefined() || NJson::TryFromJson(json, LimitedBonuses);
    }
    virtual NJson::TJsonValue ToJson() const override {
        return NJson::ToJson(LimitedBonuses);
    }
    static TFactory::TRegistrator<TBonusPaymentMeta> Registrator;
    static TFactory::TRegistrator<TBonusPaymentMeta> RegistratorCoins;
};

class TBonusLogic : public IChargeLogic {
public:
    TBonusLogic(NDrive::NBilling::EAccount bonusType, const ISettings& settings)
        : IChargeLogic(bonusType, settings)
    {}

    TChargeInfo CorrectCharge(NDrive::NBilling::IBillingAccount::TPtr, const TPaymentsData& snapshot, const TChargeInfo& chargeInfo) const override;
    virtual TString GetPaymentPrefix() const override;

private:
    virtual bool DoRefund(NDrive::NBilling::IBillingAccount::TPtr account, const TPaymentTask& payment, ui32 sum, NDrive::TEntitySession& session, NStorage::TTableRecord& newPaymentRecord) const override;
    virtual bool DoBuildPaymentTask(NDrive::NBilling::IBillingAccount::TPtr account, const TPaymentsManager& /*manager*/, const TBillingTask& /*task*/, const TChargeInfo& charge, NStorage::TTableRecord& paymentRecord) const override;
};

class TBonusLogicConfig : public ILogicConfig {
    static TFactory::TRegistrator<TBonusLogicConfig> Registrator;
    static TFactory::TRegistrator<TBonusLogicConfig> RegistratorCoins;

    NDrive::NBilling::EAccount BonusType = NDrive::NBilling::EAccount::Bonus;
public:
    virtual void Init(const TYandexConfig::Section* section, const TMap<TString, NSimpleMeta::TConfig>* /*requestPolicy*/) override;
    virtual void ToString(IOutputStream& os) const override;
    IChargeLogic::TPtr ConstructLogic(const ISettings& settings, TUsersDB& /*users*/, TAtomicSharedPtr<NDrive::INotifier> /*notifier*/) const override;
    NDrive::NBilling::EAccount GetType() const override {
        return BonusType;
    }
};
