#include "callback.h"

#include "charge_logic.h"
#include "client.h"

IPaymentMeta::TFactory::TRegistrator<TTrustPaymentMeta> TTrustPaymentMeta::Registrator(NDrive::NBilling::EAccount::Trust);
IPaymentMeta::TFactory::TRegistrator<TTrustPaymentMeta> TTrustPaymentMeta::RegistratorMobilePayment(NDrive::NBilling::EAccount::MobilePayment);
IPaymentMeta::TFactory::TRegistrator<TYCashbackPaymentMeta> TYCashbackPaymentMeta::Registrator(NDrive::NBilling::EAccount::YCashback);

namespace {
    TNamedSignalEnum<NDrive::NTrustClient::EPaymentStatus> SignalBillingStatus("billing-payments-statuses", EAggregationType::Sum, "dmmm");
    TNamedSignalSimple BillingAuthorizedSum("drive-frontend-billing-authorized");
    TNamedSignalHistogram TrustProcessingTime("billing-trust-processing-time", NRTLineHistogramSignals::IntervalsTrustProcessing);
}

TGuardedCallback::TGuardedCallback(const ITrustLogic& trustLogic, TBillingSyncGuard& guard)
    : Guard(guard)
    , TrustLogic(trustLogic)
{
    Guard.RegisterObject();
}

void TGuardedCallback::Notify(const TString& message) const {
    TrustLogic.NotifyError(GetOperation(), message);
}

TLogicCallback::TLogicCallback(ITrustLogic& trustLogic)
    : TrustLogic(trustLogic)
{
}

TLogicCallback::~TLogicCallback() {
    if (Started) {
        TrustLogic.UnRegisterObject();
    }
}

void TLogicCallback::OnRequestStart() {
    Started = true;
    TrustLogic.RegisterObject();
}

void TLogicCallback::Notify(const TString& message) const {
    TrustLogic.NotifyError(GetOperation(), message);
}
