#include "config.h"

void TBillingClientConfig::Init(const TYandexConfig::Section* section, const TMap<TString, NSimpleMeta::TConfig>* requestPolicy) {
    TAsyncApiImpl::TConfig::Init(section, requestPolicy);
    ServerThreads = section->GetDirectives().Value<ui32>("ServerThreads", ServerThreads);
    RequestTimeout = section->GetDirectives().Value<TDuration>("RequestTimeout", RequestTimeout);
    Threads = section->GetDirectives().Value("Threads", Threads);
    RequestPolicyName = section->GetDirectives().Value("RequestPolicyName", RequestPolicyName);
    HoldInterval = section->GetDirectives().Value("HoldInterval", HoldInterval);

    PaymentPath = section->GetDirectives().Value("PaymentPath", PaymentPath);
    PaymentMethodsPath = section->GetDirectives().Value("PaymentMethodsPath", PaymentMethodsPath);
    OrdersPath = section->GetDirectives().Value("OrdersPath", OrdersPath);
    RefundsPath = section->GetDirectives().Value("RefundsPath", RefundsPath);
    YAccountPath = section->GetDirectives().Value("YAccountPath", YAccountPath);
    TopupPath = section->GetDirectives().Value("TopupPath", TopupPath);
}

void TBillingClientConfig::ToString(IOutputStream& os) const {
    TAsyncApiImpl::TConfig::ToString(os);
    os << "ServerThreads: " << ServerThreads << Endl;
    os << "Threads: " << Threads << Endl;
    os << "RequestTimeout: " << RequestTimeout << Endl;
    os << "RequestPolicyName: " << RequestPolicyName << Endl;
    os << "HoldInterval: " << HoldInterval << Endl;

    os << "PaymentPath: " << PaymentPath << Endl;
    os << "PaymentMethodsPath: " << PaymentMethodsPath << Endl;
    os << "OrdersPath: " << OrdersPath << Endl;
    os << "RefundsPath: " << RefundsPath << Endl;
    os << "YAccountPath: " << YAccountPath << Endl;
    os << "TopupPath: " << TopupPath << Endl;
}
